/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.event;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Plugin;

public class AsyncEvent<T>
extends Event {
    private final Callback<T> done;
    private final Set<Plugin> intents = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean fired = new AtomicBoolean();
    private final AtomicInteger latch = new AtomicInteger();

    @Override
    public void postCall() {
        if (this.latch.get() == 0) {
            this.done.done(this, null);
        }
        this.fired.set(true);
    }

    public void registerIntent(Plugin plugin) {
        Preconditions.checkState(!this.fired.get(), "Event %s has already been fired", (Object)this);
        Preconditions.checkState(!this.intents.contains(plugin), "Plugin %s already registered intent for event %s", (Object)plugin, (Object)this);
        this.intents.add(plugin);
        this.latch.incrementAndGet();
    }

    public void completeIntent(Plugin plugin) {
        Preconditions.checkState(this.intents.contains(plugin), "Plugin %s has not registered intent for event %s", (Object)plugin, (Object)this);
        this.intents.remove(plugin);
        if (this.fired.get()) {
            if (this.latch.decrementAndGet() == 0) {
                this.done.done(this, null);
            }
        } else {
            this.latch.decrementAndGet();
        }
    }

    public AsyncEvent(Callback<T> done) {
        this.done = done;
    }

    public Callback<T> getDone() {
        return this.done;
    }

    public Set<Plugin> getIntents() {
        return this.intents;
    }

    public AtomicBoolean getFired() {
        return this.fired;
    }

    public AtomicInteger getLatch() {
        return this.latch;
    }

    public String toString() {
        return "AsyncEvent(super=" + super.toString() + ", done=" + this.getDone() + ", intents=" + this.getIntents() + ", fired=" + this.getFired() + ", latch=" + this.getLatch() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncEvent)) {
            return false;
        }
        AsyncEvent other = (AsyncEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Callback<T> this$done = this.getDone();
        Callback<T> other$done = other.getDone();
        if (this$done == null ? other$done != null : !this$done.equals(other$done)) {
            return false;
        }
        Set<Plugin> this$intents = this.getIntents();
        Set<Plugin> other$intents = other.getIntents();
        if (this$intents == null ? other$intents != null : !((Object)this$intents).equals(other$intents)) {
            return false;
        }
        AtomicBoolean this$fired = this.getFired();
        AtomicBoolean other$fired = other.getFired();
        if (this$fired == null ? other$fired != null : !this$fired.equals(other$fired)) {
            return false;
        }
        AtomicInteger this$latch = this.getLatch();
        AtomicInteger other$latch = other.getLatch();
        return !(this$latch == null ? other$latch != null : !this$latch.equals(other$latch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Callback<T> $done = this.getDone();
        result = result * 59 + ($done == null ? 43 : $done.hashCode());
        Set<Plugin> $intents = this.getIntents();
        result = result * 59 + ($intents == null ? 43 : ((Object)$intents).hashCode());
        AtomicBoolean $fired = this.getFired();
        result = result * 59 + ($fired == null ? 43 : $fired.hashCode());
        AtomicInteger $latch = this.getLatch();
        result = result * 59 + ($latch == null ? 43 : $latch.hashCode());
        return result;
    }
}

