/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;

public enum Protocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket(Handshake.class, Protocol.map(47, 0));
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket(KeepAlive.class, Protocol.map(47, 0), Protocol.map(107, 31), Protocol.map(335, 31), Protocol.map(393, 33));
            this.TO_CLIENT.registerPacket(Login.class, Protocol.map(47, 1), Protocol.map(107, 35), Protocol.map(335, 35), Protocol.map(393, 37));
            this.TO_CLIENT.registerPacket(Chat.class, Protocol.map(47, 2), Protocol.map(107, 15), Protocol.map(335, 15), Protocol.map(393, 14));
            this.TO_CLIENT.registerPacket(Respawn.class, Protocol.map(47, 7), Protocol.map(107, 51), Protocol.map(335, 52), Protocol.map(338, 53), Protocol.map(393, 56));
            this.TO_CLIENT.registerPacket(BossBar.class, Protocol.map(107, 12), Protocol.map(335, 12), Protocol.map(393, 12));
            this.TO_CLIENT.registerPacket(PlayerListItem.class, Protocol.map(47, 56), Protocol.map(107, 45), Protocol.map(335, 45), Protocol.map(338, 46), Protocol.map(393, 48));
            this.TO_CLIENT.registerPacket(TabCompleteResponse.class, Protocol.map(47, 58), Protocol.map(107, 14), Protocol.map(335, 14), Protocol.map(393, 16));
            this.TO_CLIENT.registerPacket(ScoreboardObjective.class, Protocol.map(47, 59), Protocol.map(107, 63), Protocol.map(335, 65), Protocol.map(338, 66), Protocol.map(393, 69));
            this.TO_CLIENT.registerPacket(ScoreboardScore.class, Protocol.map(47, 60), Protocol.map(107, 66), Protocol.map(335, 68), Protocol.map(338, 69), Protocol.map(393, 72));
            this.TO_CLIENT.registerPacket(ScoreboardDisplay.class, Protocol.map(47, 61), Protocol.map(107, 56), Protocol.map(335, 58), Protocol.map(338, 59), Protocol.map(393, 62));
            this.TO_CLIENT.registerPacket(Team.class, Protocol.map(47, 62), Protocol.map(107, 65), Protocol.map(335, 67), Protocol.map(338, 68), Protocol.map(393, 71));
            this.TO_CLIENT.registerPacket(PluginMessage.class, Protocol.map(47, 63), Protocol.map(107, 24), Protocol.map(335, 24), Protocol.map(393, 25));
            this.TO_CLIENT.registerPacket(Kick.class, Protocol.map(47, 64), Protocol.map(107, 26), Protocol.map(335, 26), Protocol.map(393, 27));
            this.TO_CLIENT.registerPacket(Title.class, Protocol.map(47, 69), Protocol.map(335, 71), Protocol.map(338, 72), Protocol.map(393, 75));
            this.TO_CLIENT.registerPacket(PlayerListHeaderFooter.class, Protocol.map(47, 71), Protocol.map(107, 72), Protocol.map(110, 71), Protocol.map(335, 73), Protocol.map(338, 74), Protocol.map(393, 78));
            this.TO_SERVER.registerPacket(KeepAlive.class, Protocol.map(47, 0), Protocol.map(107, 11), Protocol.map(335, 12), Protocol.map(338, 11), Protocol.map(393, 14));
            this.TO_SERVER.registerPacket(Chat.class, Protocol.map(47, 1), Protocol.map(107, 2), Protocol.map(335, 3), Protocol.map(338, 2), Protocol.map(393, 2));
            this.TO_SERVER.registerPacket(TabCompleteRequest.class, Protocol.map(47, 20), Protocol.map(107, 1), Protocol.map(335, 2), Protocol.map(338, 1), Protocol.map(393, 5));
            this.TO_SERVER.registerPacket(ClientSettings.class, Protocol.map(47, 21), Protocol.map(107, 4), Protocol.map(335, 5), Protocol.map(338, 4), Protocol.map(393, 4));
            this.TO_SERVER.registerPacket(PluginMessage.class, Protocol.map(47, 23), Protocol.map(107, 9), Protocol.map(335, 10), Protocol.map(338, 9), Protocol.map(393, 10));
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket(StatusResponse.class, Protocol.map(47, 0));
            this.TO_CLIENT.registerPacket(PingPacket.class, Protocol.map(47, 1));
            this.TO_SERVER.registerPacket(StatusRequest.class, Protocol.map(47, 0));
            this.TO_SERVER.registerPacket(PingPacket.class, Protocol.map(47, 1));
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket(Kick.class, Protocol.map(47, 0));
            this.TO_CLIENT.registerPacket(EncryptionRequest.class, Protocol.map(47, 1));
            this.TO_CLIENT.registerPacket(LoginSuccess.class, Protocol.map(47, 2));
            this.TO_CLIENT.registerPacket(SetCompression.class, Protocol.map(47, 3));
            this.TO_CLIENT.registerPacket(LoginPayloadRequest.class, Protocol.map(393, 4));
            this.TO_SERVER.registerPacket(LoginRequest.class, Protocol.map(47, 0));
            this.TO_SERVER.registerPacket(EncryptionResponse.class, Protocol.map(47, 1));
            this.TO_SERVER.registerPacket(LoginPayloadResponse.class, Protocol.map(393, 2));
        }
    };

    public static final int MAX_PACKET_ID = 255;
    public final DirectionData TO_SERVER = new DirectionData(this, ProtocolConstants.Direction.TO_SERVER);
    public final DirectionData TO_CLIENT = new DirectionData(this, ProtocolConstants.Direction.TO_CLIENT);

    public static void main(String[] args) {
        for (int version : ProtocolConstants.SUPPORTED_VERSION_IDS) {
            Protocol.dump(version);
        }
    }

    private static void dump(int version) {
        for (Protocol protocol : Protocol.values()) {
            Protocol.dump(version, protocol);
        }
    }

    private static void dump(int version, Protocol protocol) {
        Protocol.dump(version, protocol.TO_CLIENT);
        Protocol.dump(version, protocol.TO_SERVER);
    }

    private static void dump(int version, DirectionData data) {
        for (int id = 0; id < 255; ++id) {
            DefinedPacket packet = data.createPacket(id, version);
            if (packet == null) continue;
            System.out.println(version + " " + (Object)((Object)data.protocolPhase) + " " + (Object)((Object)data.direction) + " " + id + " " + packet.getClass().getSimpleName());
        }
    }

    private static ProtocolMapping map(int protocol, int id) {
        return new ProtocolMapping(protocol, id);
    }

    public static class DirectionData {
        private final Protocol protocolPhase;
        private final TIntObjectMap<ProtocolData> protocols = new TIntObjectHashMap<ProtocolData>();
        private final TIntObjectMap<List<Integer>> linkedProtocols;
        private final ProtocolConstants.Direction direction;

        private ProtocolData getProtocolData(int version) {
            ProtocolData protocol = this.protocols.get(version);
            if (protocol == null && this.protocolPhase != GAME) {
                protocol = Iterables.getFirst(this.protocols.valueCollection(), null);
            }
            return protocol;
        }

        public final DefinedPacket createPacket(int id, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            if (id > 255) {
                throw new BadPacketException("Packet with id " + id + " outside of range ");
            }
            Constructor constructor = protocolData.packetConstructors[id];
            try {
                return constructor == null ? null : (DefinedPacket)constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new BadPacketException("Could not construct packet with id " + id, ex);
            }
        }

        protected final void registerPacket(Class<? extends DefinedPacket> packetClass, ProtocolMapping ... mappings) {
            try {
                Constructor<? extends DefinedPacket> constructor = packetClass.getDeclaredConstructor(new Class[0]);
                for (ProtocolMapping mapping : mappings) {
                    ProtocolData data = this.protocols.get(mapping.protocolVersion);
                    data.packetMap.put(packetClass, mapping.packetID);
                    ((ProtocolData)data).packetConstructors[((ProtocolMapping)mapping).packetID] = constructor;
                    List<Integer> links = this.linkedProtocols.get(mapping.protocolVersion);
                    if (links == null) continue;
                    block3: for (int link : links) {
                        for (ProtocolMapping m : mappings) {
                            List<Integer> innerLinks;
                            if (m != mapping && (m.protocolVersion == link || (innerLinks = this.linkedProtocols.get(m.protocolVersion)) != null && innerLinks.contains(link))) continue block3;
                        }
                        this.registerPacket(packetClass, Protocol.map(link, mapping.packetID));
                    }
                }
            }
            catch (NoSuchMethodException ex) {
                throw new BadPacketException("No NoArgsConstructor for packet class " + packetClass);
            }
        }

        final int getId(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            Preconditions.checkArgument(protocolData.packetMap.containsKey(packet), "Cannot get ID for packet %s in phase %s with direction %s", packet, (Object)this.protocolPhase, (Object)this.direction);
            return protocolData.packetMap.get(packet);
        }

        @ConstructorProperties(value={"protocolPhase", "direction"})
        public DirectionData(Protocol protocolPhase, ProtocolConstants.Direction direction) {
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                this.protocols.put(protocol, new ProtocolData(protocol));
            }
            this.linkedProtocols = new TIntObjectHashMap<List<Integer>>();
            this.linkedProtocols.put(47, Arrays.asList(107, 335, 393));
            this.linkedProtocols.put(107, Arrays.asList(108, 109, 110));
            this.linkedProtocols.put(110, Arrays.asList(210, 315, 316));
            this.linkedProtocols.put(335, Arrays.asList(338));
            this.linkedProtocols.put(338, Arrays.asList(340));
            this.linkedProtocols.put(393, Arrays.asList(401));
            this.protocolPhase = protocolPhase;
            this.direction = direction;
        }

        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }

    private static class ProtocolMapping {
        private final int protocolVersion;
        private final int packetID;

        @ConstructorProperties(value={"protocolVersion", "packetID"})
        public ProtocolMapping(int protocolVersion, int packetID) {
            this.protocolVersion = protocolVersion;
            this.packetID = packetID;
        }
    }

    private static class ProtocolData {
        private final int protocolVersion;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap<Class<? extends DefinedPacket>>(255);
        private final Constructor<? extends DefinedPacket>[] packetConstructors = new Constructor[255];

        @ConstructorProperties(value={"protocolVersion"})
        public ProtocolData(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }
    }
}

