/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.entitymap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

class EntityMap_1_12_1
extends EntityMap {
    static final EntityMap_1_12_1 INSTANCE = new EntityMap_1_12_1();

    EntityMap_1_12_1() {
        this.addRewrite(0, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(1, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(3, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(4, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(5, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(6, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(8, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(27, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(37, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(38, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(39, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(40, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(48, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(51, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(54, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(57, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(60, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(61, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(62, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(63, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(67, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(75, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(76, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(78, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(79, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(10, ProtocolConstants.Direction.TO_SERVER, true);
        this.addRewrite(21, ProtocolConstants.Direction.TO_SERVER, true);
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public void rewriteClientbound(ByteBuf packet, int oldId, int newId) {
        super.rewriteClientbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        int jumpIndex = packet.readerIndex();
        switch (packetId) {
            case 61: {
                EntityMap_1_12_1.rewriteInt(packet, oldId, newId, readerIndex + packetIdLength + 4);
                break;
            }
            case 75: {
                DefinedPacket.readVarInt(packet);
                EntityMap_1_12_1.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
                break;
            }
            case 67: {
                DefinedPacket.readVarInt(packet);
                jumpIndex = packet.readerIndex();
            }
            case 50: {
                int count = DefinedPacket.readVarInt(packet);
                int[] ids = new int[count];
                for (int i = 0; i < count; ++i) {
                    ids[i] = DefinedPacket.readVarInt(packet);
                }
                packet.readerIndex(jumpIndex);
                packet.writerIndex(jumpIndex);
                DefinedPacket.writeVarInt(count, packet);
                for (int id : ids) {
                    if (id == oldId) {
                        id = newId;
                    } else if (id == newId) {
                        id = oldId;
                    }
                    DefinedPacket.writeVarInt(id, packet);
                }
                break;
            }
            case 0: {
                DefinedPacket.readVarInt(packet);
                DefinedPacket.readUUID(packet);
                short type = packet.readUnsignedByte();
                if (type != 60 && type != 90 && type != 91) break;
                if (type == 60 || type == 91) {
                    ++oldId;
                    ++newId;
                }
                packet.skipBytes(26);
                int position = packet.readerIndex();
                int readId = packet.readInt();
                if (readId == oldId) {
                    packet.setInt(position, newId);
                    break;
                }
                if (readId != newId) break;
                packet.setInt(position, oldId);
                break;
            }
            case 5: {
                DefinedPacket.readVarInt(packet);
                int idLength = packet.readerIndex() - readerIndex - packetIdLength;
                UUID uuid = DefinedPacket.readUUID(packet);
                UserConnection player = BungeeCord.getInstance().getPlayerByOfflineUUID(uuid);
                if (player == null) break;
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength + idLength);
                DefinedPacket.writeUUID(player.getUniqueId(), packet);
                packet.writerIndex(previous);
                break;
            }
            case 45: {
                short event = packet.readUnsignedByte();
                if (event == 1) {
                    DefinedPacket.readVarInt(packet);
                    EntityMap_1_12_1.rewriteInt(packet, oldId, newId, packet.readerIndex());
                    break;
                }
                if (event != 2) break;
                int position = packet.readerIndex();
                EntityMap_1_12_1.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
                packet.readerIndex(position);
                DefinedPacket.readVarInt(packet);
                EntityMap_1_12_1.rewriteInt(packet, oldId, newId, packet.readerIndex());
                break;
            }
            case 60: {
                DefinedPacket.readVarInt(packet);
                EntityMap_1_12_1.rewriteMetaVarInt(packet, oldId, newId, 7);
            }
        }
        packet.readerIndex(readerIndex);
    }

    @Override
    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        super.rewriteServerbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == 30 && !BungeeCord.getInstance().getConfig().isIpForward()) {
            UUID uuid = DefinedPacket.readUUID(packet);
            ProxiedPlayer player = BungeeCord.getInstance().getPlayer(uuid);
            if (player != null) {
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength);
                DefinedPacket.writeUUID(((UserConnection)player).getPendingConnection().getOfflineId(), packet);
                packet.writerIndex(previous);
            }
        }
        packet.readerIndex(readerIndex);
    }
}

