/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.entitymap;

import com.flowpowered.nbt.stream.NBTInputStream;
import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import net.md_5.bungee.entitymap.EntityMap_1_10;
import net.md_5.bungee.entitymap.EntityMap_1_11;
import net.md_5.bungee.entitymap.EntityMap_1_12;
import net.md_5.bungee.entitymap.EntityMap_1_12_1;
import net.md_5.bungee.entitymap.EntityMap_1_8;
import net.md_5.bungee.entitymap.EntityMap_1_9;
import net.md_5.bungee.entitymap.EntityMap_1_9_4;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public abstract class EntityMap {
    private final boolean[] clientboundInts = new boolean[256];
    private final boolean[] clientboundVarInts = new boolean[256];
    private final boolean[] serverboundInts = new boolean[256];
    private final boolean[] serverboundVarInts = new boolean[256];

    public static EntityMap getEntityMap(int version) {
        switch (version) {
            case 47: {
                return EntityMap_1_8.INSTANCE;
            }
            case 107: 
            case 108: 
            case 109: {
                return EntityMap_1_9.INSTANCE;
            }
            case 110: {
                return EntityMap_1_9_4.INSTANCE;
            }
            case 210: {
                return EntityMap_1_10.INSTANCE;
            }
            case 315: 
            case 316: {
                return EntityMap_1_11.INSTANCE;
            }
            case 335: {
                return EntityMap_1_12.INSTANCE;
            }
            case 338: {
                return EntityMap_1_12_1.INSTANCE;
            }
        }
        throw new RuntimeException("Version " + version + " has no entity map");
    }

    protected void addRewrite(int id, ProtocolConstants.Direction direction, boolean varint) {
        if (direction == ProtocolConstants.Direction.TO_CLIENT) {
            if (varint) {
                this.clientboundVarInts[id] = true;
            } else {
                this.clientboundInts[id] = true;
            }
        } else if (varint) {
            this.serverboundVarInts[id] = true;
        } else {
            this.serverboundInts[id] = true;
        }
    }

    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        EntityMap.rewrite(packet, oldId, newId, this.serverboundInts, this.serverboundVarInts);
    }

    public void rewriteClientbound(ByteBuf packet, int oldId, int newId) {
        EntityMap.rewrite(packet, oldId, newId, this.clientboundInts, this.clientboundVarInts);
    }

    protected static void rewriteInt(ByteBuf packet, int oldId, int newId, int offset) {
        int readId = packet.getInt(offset);
        if (readId == oldId) {
            packet.setInt(offset, newId);
        } else if (readId == newId) {
            packet.setInt(offset, oldId);
        }
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    protected static void rewriteVarInt(ByteBuf packet, int oldId, int newId, int offset) {
        int readId = DefinedPacket.readVarInt(packet);
        int readIdLength = packet.readerIndex() - offset;
        if (readId == oldId || readId == newId) {
            ByteBuf data = packet.copy();
            packet.readerIndex(offset);
            packet.writerIndex(offset);
            DefinedPacket.writeVarInt(readId == oldId ? newId : oldId, packet);
            packet.writeBytes(data);
            data.release();
        }
    }

    protected static void rewriteMetaVarInt(ByteBuf packet, int oldId, int newId, int metaIndex) {
        short index;
        int readerIndex = packet.readerIndex();
        block19: while ((index = packet.readUnsignedByte()) != 255) {
            int type = DefinedPacket.readVarInt(packet);
            switch (type) {
                case 0: {
                    packet.skipBytes(1);
                    break;
                }
                case 1: {
                    int position;
                    if (index == metaIndex) {
                        position = packet.readerIndex();
                        EntityMap.rewriteVarInt(packet, oldId, newId, position);
                        packet.readerIndex(position);
                    }
                    DefinedPacket.readVarInt(packet);
                    break;
                }
                case 2: {
                    packet.skipBytes(4);
                    break;
                }
                case 3: 
                case 4: {
                    DefinedPacket.readString(packet);
                    break;
                }
                case 5: {
                    if (packet.readShort() == -1) continue block19;
                    packet.skipBytes(3);
                    int position = packet.readerIndex();
                    if (packet.readByte() == 0) continue block19;
                    packet.readerIndex(position);
                    try {
                        new NBTInputStream(new ByteBufInputStream(packet), false).readTag();
                        break;
                    }
                    catch (IOException ex) {
                        throw Throwables.propagate(ex);
                    }
                }
                case 6: {
                    packet.skipBytes(1);
                    break;
                }
                case 7: {
                    packet.skipBytes(12);
                    break;
                }
                case 8: {
                    packet.readLong();
                    break;
                }
                case 9: {
                    if (!packet.readBoolean()) continue block19;
                    packet.skipBytes(8);
                    break;
                }
                case 10: {
                    DefinedPacket.readVarInt(packet);
                    break;
                }
                case 11: {
                    if (!packet.readBoolean()) continue block19;
                    packet.skipBytes(16);
                    break;
                }
                case 12: {
                    DefinedPacket.readVarInt(packet);
                    break;
                }
                case 13: {
                    try {
                        new NBTInputStream(new ByteBufInputStream(packet), false).readTag();
                        break;
                    }
                    catch (IOException ex) {
                        throw Throwables.propagate(ex);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown meta type " + type);
                }
            }
        }
        packet.readerIndex(readerIndex);
    }

    private static void rewrite(ByteBuf packet, int oldId, int newId, boolean[] ints, boolean[] varints) {
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (ints[packetId]) {
            EntityMap.rewriteInt(packet, oldId, newId, readerIndex + packetIdLength);
        } else if (varints[packetId]) {
            EntityMap.rewriteVarInt(packet, oldId, newId, readerIndex + packetIdLength);
        }
        packet.readerIndex(readerIndex);
    }

    EntityMap() {
    }
}

