/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.PublicKey;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.GenericConnection;
import net.md_5.bungee.KickException;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.PacketCDClientStatus;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketInputStream;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;

public class ServerConnection
extends GenericConnection
implements Server {
    private final ServerInfo info;
    public final Packet1Login loginPacket;
    public Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();

    public ServerConnection(Socket socket, ServerInfo info, PacketInputStream in, OutputStream out, Packet1Login loginPacket) {
        super(socket, in, out);
        this.info = info;
        this.loginPacket = loginPacket;
    }

    public static ServerConnection connect(UserConnection user, ServerInfo info, Packet2Handshake handshake, boolean retry) {
        try {
            Socket socket = new Socket();
            socket.bind(user.getPendingConnection().getListener().getHost());
            socket.connect(info.getAddress(), BungeeCord.getInstance().config.getTimeout());
            BungeeCord.getInstance().setSocketOptions(socket);
            PacketInputStream in = new PacketInputStream(socket.getInputStream());
            OutputStream out = socket.getOutputStream();
            out.write(handshake.getPacket());
            PacketFDEncryptionRequest encryptRequest = new PacketFDEncryptionRequest(in.readPacket());
            SecretKey myKey = EncryptionUtil.getSecret();
            PublicKey pub = EncryptionUtil.getPubkey(encryptRequest);
            PacketFCEncryptionResponse response = new PacketFCEncryptionResponse(EncryptionUtil.getShared(myKey, pub), EncryptionUtil.encrypt(pub, encryptRequest.verifyToken));
            out.write(response.getPacket());
            int ciphId = Util.getId(in.readPacket());
            if (ciphId != 252) {
                throw new RuntimeException("Server did not send encryption enable");
            }
            in = new PacketInputStream(new CipherInputStream(socket.getInputStream(), EncryptionUtil.getCipher(false, myKey)));
            out = new CipherOutputStream(out, EncryptionUtil.getCipher(true, myKey));
            for (byte[] custom : user.loginPackets) {
                out.write(custom);
            }
            out.write(new PacketCDClientStatus(0).getPacket());
            byte[] loginResponse = in.readPacket();
            if (Util.getId(loginResponse) == 255) {
                throw new KickException("[Kicked] " + new PacketFFKick((byte[])loginResponse).message);
            }
            Packet1Login login = new Packet1Login(loginResponse);
            ServerConnection server = new ServerConnection(socket, info, in, out, login);
            ServerConnectedEvent event = new ServerConnectedEvent(user, server);
            ProxyServer.getInstance().getPluginManager().callEvent(event);
            out.write(BungeeCord.getInstance().registerChannels().getPacket());
            return server;
        }
        catch (KickException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ServerInfo def = ProxyServer.getInstance().getServers().get(user.getPendingConnection().getListener().getDefaultServer());
            if (retry && !info.equals(def)) {
                user.sendMessage((Object)((Object)ChatColor.RED) + "Could not connect to target server, you have been moved to the default server");
                return ServerConnection.connect(user, def, handshake, false);
            }
            throw new RuntimeException("Could not connect to target server " + Util.exception(ex));
        }
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.packetQueue.add(new PacketFAPluginMessage(channel, data));
    }

    @Override
    public void ping(final Callback<ServerPing> callback) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Socket socket = new Socket();
                    socket.connect(ServerConnection.this.getAddress());
                    try (DataOutputStream out = new DataOutputStream(socket.getOutputStream());){
                        out.write(254);
                        out.write(1);
                    }
                    var3_4 = null;
                    try (PacketInputStream in = new PacketInputStream(socket.getInputStream());){
                        PacketFFKick response = new PacketFFKick(in.readPacket());
                        String[] split = response.message.split("\u0000");
                        ServerPing ping = new ServerPing(Byte.parseByte(split[1]), split[2], split[3], Integer.parseInt(split[4]), Integer.parseInt(split[5]));
                        callback.done(ping, null);
                    }
                    catch (Throwable throwable) {
                        var3_4 = throwable;
                        throw throwable;
                    }
                }
                catch (Throwable t) {
                    callback.done(null, t);
                }
            }
        }.start();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getInfo().getAddress();
    }

    @Override
    public ServerInfo getInfo() {
        return this.info;
    }
}

