/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexMatcher
implements ValueConverter<String> {
    private final Pattern pattern;

    public RegexMatcher(String pattern, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
    }

    public static ValueConverter<String> regex(String pattern) {
        return new RegexMatcher(pattern, 0);
    }

    @Override
    public String convert(String value) {
        if (!this.pattern.matcher(value).matches()) {
            this.raiseValueConversionFailure(value);
        }
        return value;
    }

    @Override
    public Class<String> valueType() {
        return String.class;
    }

    @Override
    public String valuePattern() {
        return this.pattern.pattern();
    }

    private void raiseValueConversionFailure(String value) {
        ResourceBundle bundle = ResourceBundle.getBundle("joptsimple.ExceptionMessages");
        String template = bundle.getString(this.getClass().getName() + ".message");
        String message = new MessageFormat(template).format(new Object[]{value, this.pattern.pattern()});
        throw new ValueConversionException(message);
    }
}

