/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.entitymap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

class EntityMap_1_8
extends EntityMap {
    static final EntityMap_1_8 INSTANCE = new EntityMap_1_8();

    EntityMap_1_8() {
        this.addRewrite(4, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(10, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(11, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(12, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(13, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(14, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(15, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(16, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(17, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(18, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(20, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(21, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(22, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(23, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(24, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(25, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(26, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(27, ProtocolConstants.Direction.TO_CLIENT, false);
        this.addRewrite(28, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(29, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(30, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(32, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(37, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(44, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(67, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(73, ProtocolConstants.Direction.TO_CLIENT, true);
        this.addRewrite(2, ProtocolConstants.Direction.TO_SERVER, true);
        this.addRewrite(11, ProtocolConstants.Direction.TO_SERVER, true);
    }

    @Override
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public void rewriteClientbound(ByteBuf packet, int oldId, int newId) {
        super.rewriteClientbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == 13) {
            DefinedPacket.readVarInt(packet);
            EntityMap_1_8.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
        } else if (packetId == 27) {
            EntityMap_1_8.rewriteInt(packet, oldId, newId, readerIndex + packetIdLength + 4);
        } else if (packetId == 19) {
            int count = DefinedPacket.readVarInt(packet);
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = DefinedPacket.readVarInt(packet);
            }
            packet.readerIndex(readerIndex + packetIdLength);
            packet.writerIndex(readerIndex + packetIdLength);
            DefinedPacket.writeVarInt(count, packet);
            for (int id : ids) {
                if (id == oldId) {
                    id = newId;
                } else if (id == newId) {
                    id = oldId;
                }
                DefinedPacket.writeVarInt(id, packet);
            }
        } else if (packetId == 14) {
            DefinedPacket.readVarInt(packet);
            short type = packet.readUnsignedByte();
            if (type == 60 || type == 90) {
                packet.skipBytes(14);
                int position = packet.readerIndex();
                int readId = packet.readInt();
                if (readId == oldId) {
                    packet.setInt(position, newId);
                } else if (readId == newId) {
                    packet.setInt(position, oldId);
                }
            }
        } else if (packetId == 12) {
            DefinedPacket.readVarInt(packet);
            int idLength = packet.readerIndex() - readerIndex - packetIdLength;
            UUID uuid = DefinedPacket.readUUID(packet);
            UserConnection player = BungeeCord.getInstance().getPlayerByOfflineUUID(uuid);
            if (player != null) {
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength + idLength);
                DefinedPacket.writeUUID(player.getUniqueId(), packet);
                packet.writerIndex(previous);
            }
        } else if (packetId == 66) {
            short event = packet.readUnsignedByte();
            if (event == 1) {
                DefinedPacket.readVarInt(packet);
                EntityMap_1_8.rewriteInt(packet, oldId, newId, packet.readerIndex());
            } else if (event == 2) {
                int position = packet.readerIndex();
                EntityMap_1_8.rewriteVarInt(packet, oldId, newId, packet.readerIndex());
                packet.readerIndex(position);
                DefinedPacket.readVarInt(packet);
                EntityMap_1_8.rewriteInt(packet, oldId, newId, packet.readerIndex());
            }
        }
        packet.readerIndex(readerIndex);
    }

    @Override
    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        super.rewriteServerbound(packet, oldId, newId);
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == 24 && !BungeeCord.getInstance().getConfig().isIpForward()) {
            UUID uuid = DefinedPacket.readUUID(packet);
            ProxiedPlayer player = BungeeCord.getInstance().getPlayer(uuid);
            if (player != null) {
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength);
                DefinedPacket.writeUUID(((UserConnection)player).getPendingConnection().getOfflineId(), packet);
                packet.writerIndex(previous);
            }
        }
        packet.readerIndex(readerIndex);
    }
}

