/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.KickException;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketInputStream;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;

public class InitialHandler
implements Runnable,
PendingConnection {
    private final Socket socket;
    private final ListenerInfo listener;
    private PacketInputStream in;
    private OutputStream out;
    private Packet2Handshake handshake;

    public InitialHandler(Socket socket, ListenerInfo info) throws IOException {
        this.socket = socket;
        this.listener = info;
        this.in = new PacketInputStream(socket.getInputStream());
        this.out = socket.getOutputStream();
    }

    @Override
    public void run() {
        try {
            byte[] packet = this.in.readPacket();
            int id = Util.getId(packet);
            switch (id) {
                case 2: {
                    byte[] custom;
                    LoginEvent event;
                    this.handshake = new Packet2Handshake(packet);
                    PacketFDEncryptionRequest request = EncryptionUtil.encryptRequest();
                    this.out.write(request.getPacket());
                    PacketFCEncryptionResponse response = new PacketFCEncryptionResponse(this.in.readPacket());
                    SecretKey shared = EncryptionUtil.getSecret(response, request);
                    if (!EncryptionUtil.isAuthenticated(this.handshake.username, request.serverId, shared)) {
                        throw new KickException("Not authenticated with minecraft.net");
                    }
                    ProxiedPlayer old = ProxyServer.getInstance().getPlayer(this.handshake.username);
                    if (old != null) {
                        old.disconnect("You are already connected to the server");
                    }
                    if ((event = new LoginEvent(this)).isCancelled()) {
                        throw new KickException(event.getCancelReason());
                    }
                    this.out.write(new PacketFCEncryptionResponse().getPacket());
                    this.in = new PacketInputStream(new CipherInputStream(this.socket.getInputStream(), EncryptionUtil.getCipher(false, shared)));
                    this.out = new CipherOutputStream(this.socket.getOutputStream(), EncryptionUtil.getCipher(true, shared));
                    ArrayList<byte[]> customPackets = new ArrayList<byte[]>();
                    while (Util.getId(custom = this.in.readPacket()) != 205) {
                        customPackets.add(custom);
                    }
                    UserConnection userCon = new UserConnection(this.socket, this, this.in, this.out, this.handshake, customPackets);
                    String server = ProxyServer.getInstance().getReconnectHandler().getServer(userCon);
                    ServerInfo s = BungeeCord.getInstance().config.getServers().get(server);
                    userCon.connect(s);
                    break;
                }
                case 254: {
                    this.socket.setSoTimeout(100);
                    boolean newPing = false;
                    try {
                        this.socket.getInputStream().read();
                        newPing = true;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ServerPing pingevent = new ServerPing(51, "1.4.6", this.listener.getMotd(), ProxyServer.getInstance().getPlayers().size(), this.listener.getMaxPlayers());
                    ProxyServer.getInstance().getPluginManager().callEvent(new ProxyPingEvent(this, pingevent));
                    String ping = newPing ? "\u00a71\u0000" + pingevent.getProtocolVersion() + "\u0000" + pingevent.getGameVersion() + "\u0000" + pingevent.getMotd() + "\u0000" + pingevent.getCurrentPlayers() + "\u0000" + pingevent.getMaxPlayers() : pingevent.getMotd() + '\u00a7' + pingevent.getCurrentPlayers() + '\u00a7' + pingevent.getMaxPlayers();
                    throw new KickException(ping);
                }
                default: {
                    if (id == 250) {
                        this.run();
                    }
                    break;
                }
            }
        }
        catch (KickException ex) {
            this.disconnect(ex.getMessage());
        }
        catch (Exception ex) {
            this.disconnect("[Proxy Error] " + Util.exception(ex));
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(String reason) {
        try {
            this.out.write(new PacketFFKick(reason).getPacket());
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                this.out.flush();
                this.socket.close();
            }
            catch (IOException ioe2) {}
        }
    }

    @Override
    public String getName() {
        return this.handshake == null ? null : this.handshake.username;
    }

    @Override
    public byte getVersion() {
        return this.handshake == null ? (byte)-1 : this.handshake.procolVersion;
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return this.handshake == null ? null : new InetSocketAddress(this.handshake.host, this.handshake.port);
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    public ListenerInfo getListener() {
        return this.listener;
    }
}

