/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.BiomeMeta;
import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkPosition;
import net.minecraft.server.ChunkProviderServer;
import net.minecraft.server.ChunkSection;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EntityTracker;
import net.minecraft.server.EntityWaterAnimal;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.Explosion;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.IntHashMap;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MethodProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NPC;
import net.minecraft.server.NextTickListEntry;
import net.minecraft.server.NoteBlockData;
import net.minecraft.server.NoteDataList;
import net.minecraft.server.Packet38EntityStatus;
import net.minecraft.server.Packet54PlayNoteBlock;
import net.minecraft.server.Packet60Explosion;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet71Weather;
import net.minecraft.server.PlayerManager;
import net.minecraft.server.SpawnerCreature;
import net.minecraft.server.StructurePieceTreasure;
import net.minecraft.server.TileEntity;
import net.minecraft.server.Vec3D;
import net.minecraft.server.WeightedRandom;
import net.minecraft.server.World;
import net.minecraft.server.WorldChunkManager;
import net.minecraft.server.WorldGenBonusChest;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldSettings;

public class WorldServer
extends World {
    private final MinecraftServer server;
    private final EntityTracker tracker;
    private final PlayerManager manager;
    private Set N;
    private TreeSet O;
    public ChunkProviderServer chunkProviderServer;
    public boolean weirdIsOpCache = false;
    public boolean savingDisabled;
    private boolean P;
    private int emptyTime = 0;
    private NoteDataList[] R = new NoteDataList[]{new NoteDataList(null), new NoteDataList(null)};
    private int S = 0;
    private static final StructurePieceTreasure[] T = new StructurePieceTreasure[]{new StructurePieceTreasure(Item.STICK.id, 0, 1, 3, 10), new StructurePieceTreasure(Block.WOOD.id, 0, 1, 3, 10), new StructurePieceTreasure(Block.LOG.id, 0, 1, 3, 10), new StructurePieceTreasure(Item.STONE_AXE.id, 0, 1, 1, 3), new StructurePieceTreasure(Item.WOOD_AXE.id, 0, 1, 1, 5), new StructurePieceTreasure(Item.STONE_PICKAXE.id, 0, 1, 1, 3), new StructurePieceTreasure(Item.WOOD_PICKAXE.id, 0, 1, 1, 5), new StructurePieceTreasure(Item.APPLE.id, 0, 2, 3, 5), new StructurePieceTreasure(Item.BREAD.id, 0, 2, 3, 3)};
    private IntHashMap entitiesById;

    public WorldServer(MinecraftServer minecraftServer, IDataManager iDataManager, String string, int n, WorldSettings worldSettings, MethodProfiler methodProfiler) {
        super(iDataManager, string, worldSettings, WorldProvider.byDimension(n), methodProfiler);
        this.server = minecraftServer;
        this.tracker = new EntityTracker(this);
        this.manager = new PlayerManager(this, minecraftServer.getServerConfigurationManager().o());
        if (this.entitiesById == null) {
            this.entitiesById = new IntHashMap();
        }
        if (this.N == null) {
            this.N = new HashSet();
        }
        if (this.O == null) {
            this.O = new TreeSet();
        }
    }

    public void doTick() {
        int n;
        super.doTick();
        if (this.getWorldData().isHardcore() && this.difficulty < 3) {
            this.difficulty = 3;
        }
        this.worldProvider.c.b();
        if (this.everyoneDeeplySleeping()) {
            n = 0;
            if (!this.allowMonsters || this.difficulty >= 1) {
                // empty if block
            }
            if (n == 0) {
                long l = this.worldData.getTime() + 24000L;
                this.worldData.b(l - l % 24000L);
                this.d();
            }
        }
        this.methodProfiler.a("mobSpawner");
        SpawnerCreature.spawnEntities(this, this.allowMonsters, this.allowAnimals && this.worldData.getTime() % 400L == 0L);
        this.methodProfiler.c("chunkSource");
        this.chunkProvider.unloadChunks();
        n = this.a(1.0f);
        if (n != this.k) {
            this.k = n;
        }
        this.Q();
        this.worldData.b(this.worldData.getTime() + 1L);
        this.methodProfiler.c("tickPending");
        this.a(false);
        this.methodProfiler.c("tickTiles");
        this.g();
        this.methodProfiler.c("chunkMap");
        this.manager.flush();
        this.methodProfiler.c("village");
        this.villages.tick();
        this.siegeManager.a();
        this.methodProfiler.b();
        this.Q();
    }

    public BiomeMeta a(EnumCreatureType enumCreatureType, int n, int n2, int n3) {
        List list = this.F().getMobsFor(enumCreatureType, n, n2, n3);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (BiomeMeta)WeightedRandom.a(this.random, list);
    }

    public void everyoneSleeping() {
        this.P = !this.players.isEmpty();
        for (EntityHuman entityHuman : this.players) {
            if (entityHuman.isSleeping()) continue;
            this.P = false;
            break;
        }
    }

    protected void d() {
        this.P = false;
        for (EntityHuman entityHuman : this.players) {
            if (!entityHuman.isSleeping()) continue;
            entityHuman.a(false, false, true);
        }
        this.P();
    }

    private void P() {
        this.worldData.setWeatherDuration(0);
        this.worldData.setStorm(false);
        this.worldData.setThunderDuration(0);
        this.worldData.setThundering(false);
    }

    public boolean everyoneDeeplySleeping() {
        if (this.P && !this.isStatic) {
            for (EntityHuman entityHuman : this.players) {
                if (entityHuman.isDeeplySleeping()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void g() {
        super.g();
        int n = 0;
        int n2 = 0;
        for (ChunkCoordIntPair chunkCoordIntPair : this.chunkTickList) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = chunkCoordIntPair.x * 16;
            int n9 = chunkCoordIntPair.z * 16;
            this.methodProfiler.a("getChunk");
            Chunk chunk = this.getChunkAt(chunkCoordIntPair.x, chunkCoordIntPair.z);
            this.a(n8, n9, chunk);
            this.methodProfiler.c("tickChunk");
            chunk.k();
            this.methodProfiler.c("thunder");
            if (this.random.nextInt(100000) == 0 && this.J() && this.I()) {
                this.l = this.l * 3 + 1013904223;
                n7 = this.l >> 2;
                n6 = n8 + (n7 & 0xF);
                n5 = n9 + (n7 >> 8 & 0xF);
                n4 = this.g(n6, n5);
                if (this.B(n6, n4, n5)) {
                    this.strikeLightning(new EntityLightning(this, n6, n4, n5));
                    this.r = 2;
                }
            }
            this.methodProfiler.c("iceandsnow");
            if (this.random.nextInt(16) == 0) {
                BiomeBase biomeBase;
                this.l = this.l * 3 + 1013904223;
                n7 = this.l >> 2;
                n6 = n7 & 0xF;
                n5 = n7 >> 8 & 0xF;
                n4 = this.g(n6 + n8, n5 + n9);
                if (this.v(n6 + n8, n4 - 1, n5 + n9)) {
                    this.setTypeId(n6 + n8, n4 - 1, n5 + n9, Block.ICE.id);
                }
                if (this.J() && this.w(n6 + n8, n4, n5 + n9)) {
                    this.setTypeId(n6 + n8, n4, n5 + n9, Block.SNOW.id);
                }
                if (this.J() && (biomeBase = this.getBiome(n6 + n8, n5 + n9)).d() && (n3 = this.getTypeId(n6 + n8, n4 - 1, n5 + n9)) != 0) {
                    Block.byId[n3].f(this, n6 + n8, n4 - 1, n5 + n9);
                }
            }
            this.methodProfiler.c("tickTiles");
            for (ChunkSection chunkSection : chunk.i()) {
                if (chunkSection == null || !chunkSection.b()) continue;
                for (int i = 0; i < 3; ++i) {
                    this.l = this.l * 3 + 1013904223;
                    n3 = this.l >> 2;
                    int n10 = n3 & 0xF;
                    int n11 = n3 >> 8 & 0xF;
                    int n12 = n3 >> 16 & 0xF;
                    int n13 = chunkSection.a(n10, n12, n11);
                    ++n2;
                    Block block = Block.byId[n13];
                    if (block == null || !block.r()) continue;
                    ++n;
                    block.b((World)this, n10 + n8, n12 + chunkSection.d(), n11 + n9, this.random);
                }
            }
            this.methodProfiler.b();
        }
    }

    public void a(int n, int n2, int n3, int n4, int n5) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        int n6 = 8;
        if (this.e) {
            int n7;
            if (this.c(nextTickListEntry.a - n6, nextTickListEntry.b - n6, nextTickListEntry.c - n6, nextTickListEntry.a + n6, nextTickListEntry.b + n6, nextTickListEntry.c + n6) && (n7 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c)) == nextTickListEntry.d && n7 > 0) {
                Block.byId[n7].b((World)this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
            }
            return;
        }
        if (this.c(n - n6, n2 - n6, n3 - n6, n + n6, n2 + n6, n3 + n6)) {
            if (n4 > 0) {
                nextTickListEntry.a((long)n5 + this.worldData.getTime());
            }
            if (!this.N.contains(nextTickListEntry)) {
                this.N.add(nextTickListEntry);
                this.O.add(nextTickListEntry);
            }
        }
    }

    public void b(int n, int n2, int n3, int n4, int n5) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        if (n4 > 0) {
            nextTickListEntry.a((long)n5 + this.worldData.getTime());
        }
        if (!this.N.contains(nextTickListEntry)) {
            this.N.add(nextTickListEntry);
            this.O.add(nextTickListEntry);
        }
    }

    public void tickEntities() {
        if (this.players.isEmpty()) {
            if (this.emptyTime++ >= 60) {
                return;
            }
        } else {
            this.emptyTime = 0;
        }
        super.tickEntities();
    }

    public boolean a(boolean bl) {
        int n = this.O.size();
        if (n != this.N.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 1000) {
            n = 1000;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            NextTickListEntry nextTickListEntry = (NextTickListEntry)this.O.first();
            if (!bl && nextTickListEntry.e > this.worldData.getTime()) break;
            this.O.remove(nextTickListEntry);
            this.N.remove(nextTickListEntry);
            int n3 = 8;
            if (!this.c(nextTickListEntry.a - n3, nextTickListEntry.b - n3, nextTickListEntry.c - n3, nextTickListEntry.a + n3, nextTickListEntry.b + n3, nextTickListEntry.c + n3) || (n2 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c)) != nextTickListEntry.d || n2 <= 0) continue;
            Block.byId[n2].b((World)this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
        }
        return !this.O.isEmpty();
    }

    public List a(Chunk chunk, boolean bl) {
        ArrayList<NextTickListEntry> arrayList = null;
        ChunkCoordIntPair chunkCoordIntPair = chunk.l();
        int n = chunkCoordIntPair.x << 4;
        int n2 = n + 16;
        int n3 = chunkCoordIntPair.z << 4;
        int n4 = n3 + 16;
        Iterator iterator = this.O.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry nextTickListEntry = (NextTickListEntry)iterator.next();
            if (nextTickListEntry.a < n || nextTickListEntry.a >= n2 || nextTickListEntry.c < n3 || nextTickListEntry.c >= n4) continue;
            if (bl) {
                this.N.remove(nextTickListEntry);
                iterator.remove();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<NextTickListEntry>();
            }
            arrayList.add(nextTickListEntry);
        }
        return arrayList;
    }

    public void entityJoinedWorld(Entity entity, boolean bl) {
        if (!this.server.getSpawnAnimals() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
            entity.die();
        }
        if (!this.server.getSpawnNPCs() && entity instanceof NPC) {
            entity.die();
        }
        if (!(entity.passenger instanceof EntityHuman)) {
            super.entityJoinedWorld(entity, bl);
        }
    }

    public void vehicleEnteredWorld(Entity entity, boolean bl) {
        super.entityJoinedWorld(entity, bl);
    }

    protected IChunkProvider i() {
        IChunkLoader iChunkLoader = this.dataManager.createChunkLoader(this.worldProvider);
        this.chunkProviderServer = new ChunkProviderServer(this, iChunkLoader, this.worldProvider.getChunkProvider());
        return this.chunkProviderServer;
    }

    public List getTileEntities(int n, int n2, int n3, int n4, int n5, int n6) {
        ArrayList<TileEntity> arrayList = new ArrayList<TileEntity>();
        for (TileEntity tileEntity : this.tileEntityList) {
            if (tileEntity.x < n || tileEntity.y < n2 || tileEntity.z < n3 || tileEntity.x >= n4 || tileEntity.y >= n5 || tileEntity.z >= n6) continue;
            arrayList.add(tileEntity);
        }
        return arrayList;
    }

    public boolean a(EntityHuman entityHuman, int n, int n2, int n3) {
        int n4;
        int n5 = MathHelper.a(n - this.worldData.c());
        if (n5 > (n4 = MathHelper.a(n3 - this.worldData.e()))) {
            n4 = n5;
        }
        return n4 > 16 || this.server.getServerConfigurationManager().isOp(entityHuman.name) || this.server.H();
    }

    protected void a(WorldSettings worldSettings) {
        if (this.entitiesById == null) {
            this.entitiesById = new IntHashMap();
        }
        if (this.N == null) {
            this.N = new HashSet();
        }
        if (this.O == null) {
            this.O = new TreeSet();
        }
        this.b(worldSettings);
        super.a(worldSettings);
    }

    protected void b(WorldSettings worldSettings) {
        if (!this.worldProvider.e()) {
            this.worldData.setSpawn(0, this.worldProvider.getSeaLevel(), 0);
            return;
        }
        this.isLoading = true;
        WorldChunkManager worldChunkManager = this.worldProvider.c;
        List list = worldChunkManager.a();
        Random random = new Random(this.getSeed());
        ChunkPosition chunkPosition = worldChunkManager.a(0, 0, 256, list, random);
        int n = 0;
        int n2 = this.worldProvider.getSeaLevel();
        int n3 = 0;
        if (chunkPosition != null) {
            n = chunkPosition.x;
            n3 = chunkPosition.z;
        } else {
            System.out.println("Unable to find spawn biome");
        }
        int n4 = 0;
        while (!this.worldProvider.canSpawn(n, n3)) {
            n += random.nextInt(64) - random.nextInt(64);
            n3 += random.nextInt(64) - random.nextInt(64);
            if (++n4 != 1000) continue;
        }
        this.worldData.setSpawn(n, n2, n3);
        this.isLoading = false;
        if (worldSettings.c()) {
            this.j();
        }
    }

    protected void j() {
        int n;
        int n2;
        int n3;
        WorldGenBonusChest worldGenBonusChest = new WorldGenBonusChest(T, 10);
        for (int i = 0; i < 10 && !worldGenBonusChest.a(this, this.random, n3 = this.worldData.c() + this.random.nextInt(6) - this.random.nextInt(6), n2 = this.h(n3, n = this.worldData.e() + this.random.nextInt(6) - this.random.nextInt(6)) + 1, n); ++i) {
        }
    }

    public ChunkCoordinates getDimensionSpawn() {
        return this.worldProvider.h();
    }

    public void save(boolean bl, IProgressUpdate iProgressUpdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (iProgressUpdate != null) {
            iProgressUpdate.a("Saving level");
        }
        this.a();
        if (iProgressUpdate != null) {
            iProgressUpdate.c("Saving chunks");
        }
        this.chunkProvider.saveChunks(bl, iProgressUpdate);
    }

    protected void a() {
        this.B();
        this.dataManager.saveWorldData(this.worldData, this.server.getServerConfigurationManager().q());
        this.worldMaps.a();
    }

    protected void a(Entity entity) {
        super.a(entity);
        this.entitiesById.a(entity.id, entity);
        Entity[] entityArray = entity.al();
        if (entityArray != null) {
            for (Entity entity2 : entityArray) {
                this.entitiesById.a(entity2.id, entity2);
            }
        }
    }

    protected void b(Entity entity) {
        super.b(entity);
        this.entitiesById.d(entity.id);
        Entity[] entityArray = entity.al();
        if (entityArray != null) {
            for (Entity entity2 : entityArray) {
                this.entitiesById.d(entity2.id);
            }
        }
    }

    public Entity getEntity(int n) {
        return (Entity)this.entitiesById.get(n);
    }

    public boolean strikeLightning(Entity entity) {
        if (super.strikeLightning(entity)) {
            this.server.getServerConfigurationManager().sendPacketNearby(entity.locX, entity.locY, entity.locZ, 512.0, this.worldProvider.dimension, new Packet71Weather(entity));
            return true;
        }
        return false;
    }

    public void broadcastEntityEffect(Entity entity, byte by) {
        Packet38EntityStatus packet38EntityStatus = new Packet38EntityStatus(entity.id, by);
        this.getTracker().sendPacketToEntity(entity, packet38EntityStatus);
    }

    public Explosion createExplosion(Entity entity, double d, double d2, double d3, float f, boolean bl) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.a = bl;
        explosion.a();
        explosion.a(false);
        for (EntityHuman entityHuman : this.players) {
            if (!(entityHuman.e(d, d2, d3) < 4096.0)) continue;
            ((EntityPlayer)entityHuman).netServerHandler.sendPacket(new Packet60Explosion(d, d2, d3, f, explosion.blocks, (Vec3D)explosion.b().get(entityHuman)));
        }
        return explosion;
    }

    public void playNote(int n, int n2, int n3, int n4, int n5, int n6) {
        NoteBlockData noteBlockData = new NoteBlockData(n, n2, n3, n4, n5, n6);
        for (NoteBlockData noteBlockData2 : this.R[this.S]) {
            if (!noteBlockData2.equals(noteBlockData)) continue;
            return;
        }
        this.R[this.S].add(noteBlockData);
    }

    private void Q() {
        while (!this.R[this.S].isEmpty()) {
            int n = this.S;
            this.S ^= 1;
            for (NoteBlockData noteBlockData : this.R[n]) {
                if (!this.a(noteBlockData)) continue;
                this.server.getServerConfigurationManager().sendPacketNearby(noteBlockData.a(), noteBlockData.b(), noteBlockData.c(), 64.0, this.worldProvider.dimension, new Packet54PlayNoteBlock(noteBlockData.a(), noteBlockData.b(), noteBlockData.c(), noteBlockData.f(), noteBlockData.d(), noteBlockData.e()));
            }
            this.R[n].clear();
        }
    }

    private boolean a(NoteBlockData noteBlockData) {
        int n = this.getTypeId(noteBlockData.a(), noteBlockData.b(), noteBlockData.c());
        if (n == noteBlockData.f()) {
            Block.byId[n].b(this, noteBlockData.a(), noteBlockData.b(), noteBlockData.c(), noteBlockData.d(), noteBlockData.e());
            return true;
        }
        return false;
    }

    public void saveLevel() {
        this.dataManager.a();
    }

    protected void m() {
        boolean bl = this.J();
        super.m();
        if (bl != this.J()) {
            if (bl) {
                this.server.getServerConfigurationManager().sendAll(new Packet70Bed(2, 0));
            } else {
                this.server.getServerConfigurationManager().sendAll(new Packet70Bed(1, 0));
            }
        }
    }

    public MinecraftServer getMinecraftServer() {
        return this.server;
    }

    public EntityTracker getTracker() {
        return this.tracker;
    }

    public void setTimeAndFixTicklists(long l) {
        long l2 = l - this.worldData.getTime();
        for (NextTickListEntry nextTickListEntry : this.N) {
            nextTickListEntry.e += l2;
        }
        for (Block block : Block.byId) {
            if (block == null) continue;
            block.a(this, l2, l);
        }
        this.setTime(l);
    }

    public PlayerManager getPlayerManager() {
        return this.manager;
    }
}

