/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EntityGolem;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.Item;
import net.minecraft.server.MathHelper;
import net.minecraft.server.PathfinderGoalArrowAttack;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.World;

public class EntitySnowman
extends EntityGolem {
    public EntitySnowman(World world) {
        super(world);
        this.texture = "/mob/snowman.png";
        this.a(0.4f, 1.8f);
        this.getNavigation().a(true);
        this.goalSelector.a(1, new PathfinderGoalArrowAttack(this, 0.25f, 2, 20));
        this.goalSelector.a(2, new PathfinderGoalRandomStroll(this, 0.2f));
        this.goalSelector.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(4, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalNearestAttackableTarget(this, EntityMonster.class, 16.0f, 0, true));
    }

    public boolean aV() {
        return true;
    }

    public int getMaxHealth() {
        return 4;
    }

    public void d() {
        int n;
        int n2;
        super.d();
        if (this.G()) {
            this.damageEntity(DamageSource.DROWN, 1);
        }
        if (this.world.getBiome(n2 = MathHelper.floor(this.locX), n = MathHelper.floor(this.locZ)).j() > 1.0f) {
            this.damageEntity(DamageSource.BURN, 1);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            int n3;
            int n4;
            n = MathHelper.floor(this.locX + (double)((float)(n2 % 2 * 2 - 1) * 0.25f));
            if (this.world.getTypeId(n, n4 = MathHelper.floor(this.locY), n3 = MathHelper.floor(this.locZ + (double)((float)(n2 / 2 % 2 * 2 - 1) * 0.25f))) != 0 || !(this.world.getBiome(n, n3).j() < 0.8f) || !Block.SNOW.canPlace(this.world, n, n4, n3)) continue;
            this.world.setTypeId(n, n4, n3, Block.SNOW.id);
        }
    }

    protected int getLootId() {
        return Item.SNOW_BALL.id;
    }

    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.random.nextInt(16);
        for (int i = 0; i < n2; ++i) {
            this.b(Item.SNOW_BALL.id, 1);
        }
    }
}

