/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentManager;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EnumMonsterType;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.PathfinderGoalArrowAttack;
import net.minecraft.server.PathfinderGoalFleeSun;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalHurtByTarget;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalNearestAttackableTarget;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalRestrictSun;
import net.minecraft.server.World;

public class EntitySkeleton
extends EntityMonster {
    private static final ItemStack d = new ItemStack(Item.BOW, 1);

    public EntitySkeleton(World world) {
        super(world);
        this.texture = "/mob/skeleton.png";
        this.bw = 0.25f;
        this.goalSelector.a(1, new PathfinderGoalFloat(this));
        this.goalSelector.a(2, new PathfinderGoalRestrictSun(this));
        this.goalSelector.a(3, new PathfinderGoalFleeSun(this, this.bw));
        this.goalSelector.a(4, new PathfinderGoalArrowAttack(this, this.bw, 1, 60));
        this.goalSelector.a(5, new PathfinderGoalRandomStroll(this, this.bw));
        this.goalSelector.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.a(6, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.a(1, new PathfinderGoalHurtByTarget(this, false));
        this.targetSelector.a(2, new PathfinderGoalNearestAttackableTarget(this, EntityHuman.class, 16.0f, 0, true));
    }

    public boolean aV() {
        return true;
    }

    public int getMaxHealth() {
        return 20;
    }

    protected String aQ() {
        return "mob.skeleton";
    }

    protected String aR() {
        return "mob.skeletonhurt";
    }

    protected String aS() {
        return "mob.skeletonhurt";
    }

    public EnumMonsterType getMonsterType() {
        return EnumMonsterType.UNDEAD;
    }

    public void d() {
        float f;
        if (this.world.s() && !this.world.isStatic && (f = this.c(1.0f)) > 0.5f && this.world.j(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.setOnFire(8);
        }
        super.d();
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (damageSource.f() instanceof EntityArrow && damageSource.getEntity() instanceof EntityHuman) {
            EntityHuman entityHuman = (EntityHuman)damageSource.getEntity();
            double d = entityHuman.locX - this.locX;
            double d2 = entityHuman.locZ - this.locZ;
            if (d * d + d2 * d2 >= 2500.0) {
                entityHuman.a(AchievementList.v);
            }
        }
    }

    protected int getLootId() {
        return Item.ARROW.id;
    }

    protected void dropDeathLoot(boolean bl, int n) {
        int n2;
        int n3 = this.random.nextInt(3 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.ARROW.id, 1);
        }
        n3 = this.random.nextInt(3 + n);
        for (n2 = 0; n2 < n3; ++n2) {
            this.b(Item.BONE.id, 1);
        }
    }

    protected void l(int n) {
        if (n > 0) {
            ItemStack itemStack = new ItemStack(Item.BOW);
            EnchantmentManager.a(this.random, itemStack, 5);
            this.a(itemStack, 0.0f);
        } else {
            this.b(Item.BOW.id, 1);
        }
    }
}

