/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityArrow
extends Entity {
    private int d = -1;
    private int e = -1;
    private int f = -1;
    private int g = 0;
    private int h = 0;
    private boolean inGround = false;
    public int fromPlayer = 0;
    public int shake = 0;
    public Entity shooter;
    private int j;
    private int an = 0;
    private double damage = 2.0;
    private int ap;

    public EntityArrow(World world) {
        super(world);
        this.a(0.5f, 0.5f);
    }

    public EntityArrow(World world, double d, double d2, double d3) {
        super(world);
        this.a(0.5f, 0.5f);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
    }

    public EntityArrow(World world, EntityLiving entityLiving, EntityLiving entityLiving2, float f, float f2) {
        super(world);
        this.shooter = entityLiving;
        if (entityLiving instanceof EntityHuman) {
            this.fromPlayer = 1;
        }
        this.locY = entityLiving.locY + (double)entityLiving.getHeadHeight() - (double)0.1f;
        double d = entityLiving2.locX - entityLiving.locX;
        double d2 = entityLiving2.locY + (double)entityLiving2.getHeadHeight() - (double)0.7f - this.locY;
        double d3 = entityLiving2.locZ - entityLiving.locZ;
        double d4 = MathHelper.sqrt(d * d + d3 * d3);
        if (d4 < 1.0E-7) {
            return;
        }
        float f3 = (float)(Math.atan2(d3, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f4 = (float)(-(Math.atan2(d2, d4) * 180.0 / 3.1415927410125732));
        double d5 = d / d4;
        double d6 = d3 / d4;
        this.setPositionRotation(entityLiving.locX + d5, this.locY, entityLiving.locZ + d6, f3, f4);
        this.height = 0.0f;
        float f5 = (float)d4 * 0.2f;
        this.shoot(d, d2 + (double)f5, d3, f, f2);
    }

    public EntityArrow(World world, EntityLiving entityLiving, float f) {
        super(world);
        this.shooter = entityLiving;
        if (entityLiving instanceof EntityHuman) {
            this.fromPlayer = 1;
        }
        this.a(0.5f, 0.5f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.getHeadHeight(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.locY -= (double)0.1f;
        this.locZ -= (double)(MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI);
        this.shoot(this.motX, this.motY, this.motZ, f * 1.5f, 1.0f);
    }

    protected void a() {
        this.datawatcher.a(16, (byte)0);
    }

    public void shoot(double d, double d2, double d3, float f, float f2) {
        float f3 = MathHelper.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        this.motX = d *= (double)f;
        this.motY = d2 *= (double)f;
        this.motZ = d3 *= (double)f;
        float f4 = MathHelper.sqrt(d * d + d3 * d3);
        this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.lastPitch = this.pitch = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.j = 0;
    }

    public void h_() {
        Object object;
        int n;
        super.h_();
        if (this.lastPitch == 0.0f && this.lastYaw == 0.0f) {
            float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            this.lastYaw = this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
            this.lastPitch = this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        }
        if ((n = this.world.getTypeId(this.d, this.e, this.f)) > 0) {
            Block.byId[n].updateShape(this.world, this.d, this.e, this.f);
            object = Block.byId[n].e(this.world, this.d, this.e, this.f);
            if (object != null && ((AxisAlignedBB)object).a(Vec3D.a().create(this.locX, this.locY, this.locZ))) {
                this.inGround = true;
            }
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.inGround) {
            int n2 = this.world.getTypeId(this.d, this.e, this.f);
            int n3 = this.world.getData(this.d, this.e, this.f);
            if (n2 != this.g || n3 != this.h) {
                this.inGround = false;
                this.motX *= (double)(this.random.nextFloat() * 0.2f);
                this.motY *= (double)(this.random.nextFloat() * 0.2f);
                this.motZ *= (double)(this.random.nextFloat() * 0.2f);
                this.j = 0;
                this.an = 0;
                return;
            }
            ++this.j;
            if (this.j == 1200) {
                this.die();
            }
            return;
        }
        ++this.an;
        object = Vec3D.a().create(this.locX, this.locY, this.locZ);
        Vec3D vec3D = Vec3D.a().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        MovingObjectPosition movingObjectPosition = this.world.rayTrace((Vec3D)object, vec3D, false, true);
        object = Vec3D.a().create(this.locX, this.locY, this.locZ);
        vec3D = Vec3D.a().create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
        if (movingObjectPosition != null) {
            vec3D = Vec3D.a().create(movingObjectPosition.pos.a, movingObjectPosition.pos.b, movingObjectPosition.pos.c);
        }
        Entity entity = null;
        List list = this.world.getEntities(this, this.boundingBox.a(this.motX, this.motY, this.motZ).grow(1.0, 1.0, 1.0));
        double d = 0.0;
        for (Entity entity2 : list) {
            double d2;
            float f;
            AxisAlignedBB axisAlignedBB;
            MovingObjectPosition movingObjectPosition2;
            if (!entity2.L() || entity2 == this.shooter && this.an < 5 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.grow(f = 0.3f, f, f)).a((Vec3D)object, vec3D)) == null || !((d2 = ((Vec3D)object).d(movingObjectPosition2.pos)) < d) && d != 0.0) continue;
            entity = entity2;
            d = d2;
        }
        if (entity != null) {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
        if (movingObjectPosition != null) {
            if (movingObjectPosition.entity != null) {
                float f = MathHelper.sqrt(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
                int n4 = MathHelper.f((double)f * this.damage);
                if (this.g()) {
                    n4 += this.random.nextInt(n4 / 2 + 2);
                }
                DamageSource damageSource = null;
                damageSource = this.shooter == null ? DamageSource.arrow(this, this) : DamageSource.arrow(this, this.shooter);
                if (this.isBurning()) {
                    movingObjectPosition.entity.setOnFire(5);
                }
                if (movingObjectPosition.entity.damageEntity(damageSource, n4)) {
                    if (movingObjectPosition.entity instanceof EntityLiving) {
                        float f2;
                        ++((EntityLiving)movingObjectPosition.entity).bd;
                        if (this.ap > 0 && (f2 = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ)) > 0.0f) {
                            movingObjectPosition.entity.g(this.motX * (double)this.ap * (double)0.6f / (double)f2, 0.1, this.motZ * (double)this.ap * (double)0.6f / (double)f2);
                        }
                    }
                    this.world.makeSound(this, "random.bowhit", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                    this.die();
                } else {
                    this.motX *= (double)-0.1f;
                    this.motY *= (double)-0.1f;
                    this.motZ *= (double)-0.1f;
                    this.yaw += 180.0f;
                    this.lastYaw += 180.0f;
                    this.an = 0;
                }
            } else {
                this.d = movingObjectPosition.b;
                this.e = movingObjectPosition.c;
                this.f = movingObjectPosition.d;
                this.g = this.world.getTypeId(this.d, this.e, this.f);
                this.h = this.world.getData(this.d, this.e, this.f);
                this.motX = (float)(movingObjectPosition.pos.a - this.locX);
                this.motY = (float)(movingObjectPosition.pos.b - this.locY);
                this.motZ = (float)(movingObjectPosition.pos.c - this.locZ);
                float f = MathHelper.sqrt(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
                this.locX -= this.motX / (double)f * (double)0.05f;
                this.locY -= this.motY / (double)f * (double)0.05f;
                this.locZ -= this.motZ / (double)f * (double)0.05f;
                this.world.makeSound(this, "random.bowhit", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                this.inGround = true;
                this.shake = 7;
                this.d(false);
            }
        }
        if (this.g()) {
            for (int i = 0; i < 4; ++i) {
                this.world.a("crit", this.locX + this.motX * (double)i / 4.0, this.locY + this.motY * (double)i / 4.0, this.locZ + this.motZ * (double)i / 4.0, -this.motX, -this.motY + 0.2, -this.motZ);
            }
        }
        this.locX += this.motX;
        this.locY += this.motY;
        this.locZ += this.motZ;
        float f = MathHelper.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
        this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        while (this.pitch - this.lastPitch < -180.0f) {
            this.lastPitch -= 360.0f;
        }
        while (this.pitch - this.lastPitch >= 180.0f) {
            this.lastPitch += 360.0f;
        }
        while (this.yaw - this.lastYaw < -180.0f) {
            this.lastYaw -= 360.0f;
        }
        while (this.yaw - this.lastYaw >= 180.0f) {
            this.lastYaw += 360.0f;
        }
        this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
        this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
        float f3 = 0.99f;
        float f4 = 0.05f;
        if (this.H()) {
            for (int i = 0; i < 4; ++i) {
                float f5 = 0.25f;
                this.world.a("bubble", this.locX - this.motX * (double)f5, this.locY - this.motY * (double)f5, this.locZ - this.motZ * (double)f5, this.motX, this.motY, this.motZ);
            }
            f3 = 0.8f;
        }
        this.motX *= (double)f3;
        this.motY *= (double)f3;
        this.motZ *= (double)f3;
        this.motY -= (double)f4;
        this.setPosition(this.locX, this.locY, this.locZ);
        this.D();
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("xTile", (short)this.d);
        nBTTagCompound.setShort("yTile", (short)this.e);
        nBTTagCompound.setShort("zTile", (short)this.f);
        nBTTagCompound.setByte("inTile", (byte)this.g);
        nBTTagCompound.setByte("inData", (byte)this.h);
        nBTTagCompound.setByte("shake", (byte)this.shake);
        nBTTagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nBTTagCompound.setByte("pickup", (byte)this.fromPlayer);
        nBTTagCompound.setDouble("damage", this.damage);
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.d = nBTTagCompound.getShort("xTile");
        this.e = nBTTagCompound.getShort("yTile");
        this.f = nBTTagCompound.getShort("zTile");
        this.g = nBTTagCompound.getByte("inTile") & 0xFF;
        this.h = nBTTagCompound.getByte("inData") & 0xFF;
        this.shake = nBTTagCompound.getByte("shake") & 0xFF;
        boolean bl = this.inGround = nBTTagCompound.getByte("inGround") == 1;
        if (nBTTagCompound.hasKey("damage")) {
            this.damage = nBTTagCompound.getDouble("damage");
        }
        if (nBTTagCompound.hasKey("pickup")) {
            this.fromPlayer = nBTTagCompound.getByte("pickup");
        } else if (nBTTagCompound.hasKey("player")) {
            this.fromPlayer = nBTTagCompound.getBoolean("player") ? 1 : 0;
        }
    }

    public void b_(EntityHuman entityHuman) {
        boolean bl;
        if (this.world.isStatic || !this.inGround || this.shake > 0) {
            return;
        }
        boolean bl2 = bl = this.fromPlayer == 1 || this.fromPlayer == 2 && entityHuman.abilities.canInstantlyBuild;
        if (this.fromPlayer == 1 && !entityHuman.inventory.pickup(new ItemStack(Item.ARROW, 1))) {
            bl = false;
        }
        if (bl) {
            this.world.makeSound(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityHuman.receive(this, 1);
            this.die();
        }
    }

    public void b(double d) {
        this.damage = d;
    }

    public double d() {
        return this.damage;
    }

    public void a(int n) {
        this.ap = n;
    }

    public boolean an() {
        return false;
    }

    public void d(boolean bl) {
        byte by = this.datawatcher.getByte(16);
        if (bl) {
            this.datawatcher.watch(16, (byte)(by | 1));
        } else {
            this.datawatcher.watch(16, (byte)(by & 0xFFFFFFFE));
        }
    }

    public boolean g() {
        byte by = this.datawatcher.getByte(16);
        return (by & 1) != 0;
    }
}

