/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.Chunk;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Material;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;

public class ChunkCache
implements IBlockAccess {
    private int a;
    private int b;
    private Chunk[][] c;
    private boolean d;
    private World e;

    public ChunkCache(World world, int n, int n2, int n3, int n4, int n5, int n6) {
        this.e = world;
        this.a = n >> 4;
        this.b = n3 >> 4;
        int n7 = n4 >> 4;
        int n8 = n6 >> 4;
        this.c = new Chunk[n7 - this.a + 1][n8 - this.b + 1];
        this.d = true;
        for (int i = this.a; i <= n7; ++i) {
            for (int j = this.b; j <= n8; ++j) {
                Chunk chunk = world.getChunkAt(i, j);
                if (chunk == null) continue;
                this.c[i - this.a][j - this.b] = chunk;
                if (chunk.c(n2, n5)) continue;
                this.d = false;
            }
        }
    }

    public int getTypeId(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            return 0;
        }
        int n4 = (n >> 4) - this.a;
        int n5 = (n3 >> 4) - this.b;
        if (n4 < 0 || n4 >= this.c.length || n5 < 0 || n5 >= this.c[n4].length) {
            return 0;
        }
        Chunk chunk = this.c[n4][n5];
        if (chunk == null) {
            return 0;
        }
        return chunk.getTypeId(n & 0xF, n2, n3 & 0xF);
    }

    public TileEntity getTileEntity(int n, int n2, int n3) {
        int n4 = (n >> 4) - this.a;
        int n5 = (n3 >> 4) - this.b;
        return this.c[n4][n5].e(n & 0xF, n2, n3 & 0xF);
    }

    public int getData(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 256) {
            return 0;
        }
        int n4 = (n >> 4) - this.a;
        int n5 = (n3 >> 4) - this.b;
        return this.c[n4][n5].getData(n & 0xF, n2, n3 & 0xF);
    }

    public Material getMaterial(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        if (n4 == 0) {
            return Material.AIR;
        }
        return Block.byId[n4].material;
    }

    public boolean s(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        if (block == null) {
            return false;
        }
        return block.material.isSolid() && block.c();
    }
}

