/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import net.md_5.bungee.protocol.DefinedPacket;

public class Varint21FrameDecoder
extends ByteToMessageDecoder {
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        byte[] buf = new byte[3];
        for (int i = 0; i < buf.length; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            buf[i] = in.readByte();
            if (buf[i] < 0) continue;
            int length = DefinedPacket.readVarInt(Unpooled.wrappedBuffer(buf));
            if (length == 0) {
                throw new CorruptedFrameException("Empty Packet!");
            }
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            ByteBuf dst = ctx.alloc().directBuffer(length);
            in.readBytes(dst);
            out.add(dst);
            return;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }
}

