/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.forge;

import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.Map;
import lombok.NonNull;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.forge.ForgeClientHandshakeState;
import net.md_5.bungee.forge.ForgeConstants;
import net.md_5.bungee.forge.ForgeLogger;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class ForgeClientHandler {
    @NonNull
    private final UserConnection con;
    private boolean forgeOutdated = false;
    private Map<String, String> clientModList = null;
    private final ArrayDeque<PluginMessage> packetQueue = new ArrayDeque();
    @NonNull
    private ForgeClientHandshakeState state = ForgeClientHandshakeState.HELLO;
    private PluginMessage serverModList = null;
    private PluginMessage serverIdList = null;
    private boolean fmlTokenInHandshake = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(PluginMessage message) throws IllegalArgumentException {
        if (!message.getTag().equalsIgnoreCase("FML|HS")) {
            throw new IllegalArgumentException("Expecting a Forge Handshake packet.");
        }
        message.setAllowExtendedPacket(true);
        ForgeClientHandshakeState prevState = this.state;
        this.packetQueue.add(message);
        this.state = (ForgeClientHandshakeState)this.state.send(message, this.con);
        if (this.state != prevState) {
            ArrayDeque<PluginMessage> arrayDeque = this.packetQueue;
            synchronized (arrayDeque) {
                while (!this.packetQueue.isEmpty()) {
                    ForgeLogger.logClient(ForgeLogger.LogDirection.SENDING, prevState.name(), this.packetQueue.getFirst());
                    this.con.getForgeServerHandler().receive(this.packetQueue.removeFirst());
                }
            }
        }
    }

    public void receive(PluginMessage message) throws IllegalArgumentException {
        this.state = (ForgeClientHandshakeState)this.state.handle(message, this.con);
    }

    public void resetHandshake() {
        this.state = ForgeClientHandshakeState.HELLO;
        this.con.unsafe().sendPacket(ForgeConstants.FML_RESET_HANDSHAKE);
    }

    public void setServerModList(PluginMessage modList) throws IllegalArgumentException {
        if (!modList.getTag().equalsIgnoreCase("FML|HS") || modList.getData()[0] != 2) {
            throw new IllegalArgumentException("modList");
        }
        this.serverModList = modList;
    }

    public void setServerIdList(PluginMessage idList) throws IllegalArgumentException {
        if (!idList.getTag().equalsIgnoreCase("FML|HS") || idList.getData()[0] != 3) {
            throw new IllegalArgumentException("idList");
        }
        this.serverIdList = idList;
    }

    public boolean isHandshakeComplete() {
        return this.state == ForgeClientHandshakeState.DONE;
    }

    public void setHandshakeComplete() {
        this.state = ForgeClientHandshakeState.DONE;
    }

    public boolean isForgeUser() {
        return this.fmlTokenInHandshake || this.clientModList != null;
    }

    public boolean checkUserOutdated() {
        if (this.forgeOutdated) {
            if (this.con.isDimensionChange()) {
                this.con.disconnect(BungeeCord.getInstance().getTranslation("connect_kick_outdated_forge", new Object[0]));
            } else {
                this.con.sendMessage(BungeeCord.getInstance().getTranslation("connect_kick_outdated_forge", new Object[0]));
            }
        }
        return this.forgeOutdated;
    }

    @ConstructorProperties(value={"con"})
    public ForgeClientHandler(@NonNull UserConnection con) {
        if (con == null) {
            throw new NullPointerException("con");
        }
        this.con = con;
    }

    public boolean isForgeOutdated() {
        return this.forgeOutdated;
    }

    void setForgeOutdated(boolean forgeOutdated) {
        this.forgeOutdated = forgeOutdated;
    }

    public Map<String, String> getClientModList() {
        return this.clientModList;
    }

    void setClientModList(Map<String, String> clientModList) {
        this.clientModList = clientModList;
    }

    void setState(@NonNull ForgeClientHandshakeState state) {
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.state = state;
    }

    public boolean isFmlTokenInHandshake() {
        return this.fmlTokenInHandshake;
    }

    public void setFmlTokenInHandshake(boolean fmlTokenInHandshake) {
        this.fmlTokenInHandshake = fmlTokenInHandshake;
    }
}

