/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.Logger;
import net.md_5.bungee.Permission;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.command.CommandSender;
import net.md_5.bungee.command.ConsoleCommandSender;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Configuration {
    private transient File reconnect = new File("locations.yml");
    private transient Map<String, String> reconnectLocations;
    private transient File file = new File("config.yml");
    private transient Yaml yaml;
    private transient Map<String, Object> config;
    public String bindHost = "0.0.0.0:25577";
    public String motd = "BungeeCord Proxy Instance";
    public String defaultServerName = "default";
    public int maxPlayers = 1;
    public int timeout = 15000;
    public Map<String, String> servers = new HashMap<String, String>(){
        {
            this.put(Configuration.this.defaultServerName, "127.0.0.1:1338");
            this.put("pvp", "127.0.0.1:1337");
        }
    };
    public Map<String, String> forcedServers = new HashMap<String, String>(){
        {
            this.put("pvp.md-5.net", "pvp");
        }
    };
    public List<String> admins = new ArrayList<String>(){
        {
            this.add("md_5");
        }
    };
    public List<String> moderators = new ArrayList<String>(){
        {
            this.add("mbaxter");
        }
    };
    public List<String> disabledCommands = new ArrayList<String>(){
        {
            this.add("glist");
        }
    };
    public int logNumLines = 16384;
    public String statsUuid = UUID.randomUUID().toString();

    public void load() {
        try {
            this.file.createNewFile();
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yaml = new Yaml(options);
            try (FileInputStream is = new FileInputStream(this.file);){
                this.config = (Map)this.yaml.load(is);
            }
            if (this.config == null) {
                this.config = new LinkedHashMap<String, Object>();
            }
            Logger.$().info("-------------- Loading configuration ----------------");
            for (Field field : this.getClass().getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                String name = Util.normalize(field.getName());
                try {
                    Object def = field.get(this);
                    Object value = this.get(name, def);
                    field.set(this, value);
                    Logger.$().info(name + ": " + value);
                }
                catch (IllegalAccessException ex) {
                    Logger.$().severe("Could not get config node: " + name);
                }
            }
            Logger.$().info("-----------------------------------------------------");
            if (this.servers.get(this.defaultServerName) == null) {
                throw new IllegalArgumentException("Server '" + this.defaultServerName + "' not defined");
            }
            for (String server : this.forcedServers.values()) {
                if (this.servers.containsKey(server)) continue;
                throw new IllegalArgumentException("Forced server " + server + " is not defined in servers");
            }
            this.reconnect.createNewFile();
            try (FileInputStream recon = new FileInputStream(this.reconnect);){
                this.reconnectLocations = (Map)this.yaml.load(recon);
            }
            if (this.reconnectLocations == null) {
                this.reconnectLocations = new LinkedHashMap<String, String>();
            }
        }
        catch (IOException ex) {
            Logger.$().severe("Could not load config!");
            ex.printStackTrace();
        }
    }

    private <T> T get(String path, T def) {
        if (!this.config.containsKey(path)) {
            this.config.put(path, def);
            this.save(this.file, this.config);
        }
        return (T)this.config.get(path);
    }

    private void save(File fileToSave, Map toSave) {
        try (FileWriter wr = new FileWriter(fileToSave);){
            this.yaml.dump(toSave, wr);
        }
        catch (IOException ex) {
            Logger.$().severe("Could not save config file " + fileToSave);
            ex.printStackTrace();
        }
    }

    public String getServer(String user, String requestedHost) {
        String server = this.forcedServers.get(requestedHost);
        if (server == null) {
            server = this.reconnectLocations.get(user);
        }
        if (server == null) {
            server = this.servers.get(this.defaultServerName);
        }
        return server;
    }

    public void setServer(UserConnection user, String server) {
        this.reconnectLocations.put(user.username, server);
    }

    public InetSocketAddress getServer(String name) {
        String server = this.servers.get(name == null ? this.defaultServerName : name);
        return server != null ? Util.getAddr(server) : this.getServer(null);
    }

    public void saveHosts() {
        this.save(this.reconnect, this.reconnectLocations);
        Logger.$().info("Saved reconnect locations to " + this.reconnect);
    }

    public Permission getPermission(CommandSender sender) {
        Permission permission = Permission.DEFAULT;
        if (this.admins.contains(sender.getName()) || sender instanceof ConsoleCommandSender) {
            permission = Permission.ADMIN;
        } else if (this.moderators.contains(sender.getName())) {
            permission = Permission.MODERATOR;
        }
        return permission;
    }
}

