/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityBoat
extends Entity {
    private boolean a = true;
    private double b = 0.07;
    private int c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;

    public EntityBoat(World world) {
        super(world);
        this.m = true;
        this.a(1.5f, 0.6f);
        this.height = this.length / 2.0f;
    }

    protected boolean e_() {
        return false;
    }

    protected void a() {
        this.datawatcher.a(17, new Integer(0));
        this.datawatcher.a(18, new Integer(1));
        this.datawatcher.a(19, new Integer(0));
    }

    public AxisAlignedBB g(Entity entity) {
        return entity.boundingBox;
    }

    public AxisAlignedBB E() {
        return this.boundingBox;
    }

    public boolean M() {
        return true;
    }

    public EntityBoat(World world, double d, double d2, double d3) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
    }

    public double X() {
        return (double)this.length * 0.0 - (double)0.3f;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.world.isStatic || this.dead) {
            return true;
        }
        this.c(-this.i());
        this.b(10);
        this.setDamage(this.getDamage() + n * 10);
        this.K();
        if (damageSource.getEntity() instanceof EntityHuman && ((EntityHuman)damageSource.getEntity()).abilities.canInstantlyBuild) {
            this.setDamage(100);
        }
        if (this.getDamage() > 40) {
            if (this.passenger != null) {
                this.passenger.mount(this);
            }
            this.a(Item.BOAT.id, 1, 0.0f);
            this.die();
        }
        return true;
    }

    public boolean L() {
        return !this.dead;
    }

    public void h_() {
        double d;
        double d2;
        double d3;
        super.h_();
        if (this.h() > 0) {
            this.b(this.h() - 1);
        }
        if (this.getDamage() > 0) {
            this.setDamage(this.getDamage() - 1);
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        int n = 5;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 0) / (double)n - 0.125;
            double d6 = this.boundingBox.b + (this.boundingBox.e - this.boundingBox.b) * (double)(i + 1) / (double)n - 0.125;
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.a().a(this.boundingBox.a, d5, this.boundingBox.c, this.boundingBox.d, d6, this.boundingBox.f);
            if (!this.world.b(axisAlignedBB, Material.WATER)) continue;
            d4 += 1.0 / (double)n;
        }
        double d7 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
        if (d7 > 0.26249999999999996) {
            d3 = Math.cos((double)this.yaw * Math.PI / 180.0);
            d2 = Math.sin((double)this.yaw * Math.PI / 180.0);
            int n2 = 0;
            while ((double)n2 < 1.0 + d7 * 60.0) {
                double d8;
                double d9;
                double d10 = this.random.nextFloat() * 2.0f - 1.0f;
                double d11 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                if (this.random.nextBoolean()) {
                    d9 = this.locX - d3 * d10 * 0.8 + d2 * d11;
                    d8 = this.locZ - d2 * d10 * 0.8 - d3 * d11;
                    this.world.a("splash", d9, this.locY - 0.125, d8, this.motX, this.motY, this.motZ);
                } else {
                    d9 = this.locX + d3 + d2 * d10 * 0.7;
                    d8 = this.locZ + d2 - d3 * d10 * 0.7;
                    this.world.a("splash", d9, this.locY - 0.125, d8, this.motX, this.motY, this.motZ);
                }
                ++n2;
            }
        }
        if (this.world.isStatic && this.a) {
            if (this.c > 0) {
                d3 = this.locX + (this.d - this.locX) / (double)this.c;
                d2 = this.locY + (this.e - this.locY) / (double)this.c;
                double d12 = this.locZ + (this.f - this.locZ) / (double)this.c;
                double d13 = MathHelper.g(this.g - (double)this.yaw);
                this.yaw = (float)((double)this.yaw + d13 / (double)this.c);
                this.pitch = (float)((double)this.pitch + (this.h - (double)this.pitch) / (double)this.c);
                --this.c;
                this.setPosition(d3, d2, d12);
                this.b(this.yaw, this.pitch);
            } else {
                d3 = this.locX + this.motX;
                d2 = this.locY + this.motY;
                double d14 = this.locZ + this.motZ;
                this.setPosition(d3, d2, d14);
                if (this.onGround) {
                    this.motX *= 0.5;
                    this.motY *= 0.5;
                    this.motZ *= 0.5;
                }
                this.motX *= (double)0.99f;
                this.motY *= (double)0.95f;
                this.motZ *= (double)0.99f;
            }
            return;
        }
        if (d4 < 1.0) {
            d3 = d4 * 2.0 - 1.0;
            this.motY += (double)0.04f * d3;
        } else {
            if (this.motY < 0.0) {
                this.motY /= 2.0;
            }
            this.motY += (double)0.007f;
        }
        if (this.passenger != null) {
            this.motX += this.passenger.motX * this.b;
            this.motZ += this.passenger.motZ * this.b;
        }
        if ((d3 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ)) > 0.35) {
            d2 = 0.35 / d3;
            this.motX *= d2;
            this.motZ *= d2;
            d3 = 0.35;
        }
        if (d3 > d7 && this.b < 0.35) {
            this.b += (0.35 - this.b) / 35.0;
            if (this.b > 0.35) {
                this.b = 0.35;
            }
        } else {
            this.b -= (this.b - 0.07) / 35.0;
            if (this.b < 0.07) {
                this.b = 0.07;
            }
        }
        if (this.onGround) {
            this.motX *= 0.5;
            this.motY *= 0.5;
            this.motZ *= 0.5;
        }
        this.move(this.motX, this.motY, this.motZ);
        if (this.positionChanged && d7 > 0.2) {
            if (!this.world.isStatic) {
                int n3;
                this.die();
                for (n3 = 0; n3 < 3; ++n3) {
                    this.a(Block.WOOD.id, 1, 0.0f);
                }
                for (n3 = 0; n3 < 2; ++n3) {
                    this.a(Item.STICK.id, 1, 0.0f);
                }
            }
        } else {
            this.motX *= (double)0.99f;
            this.motY *= (double)0.95f;
            this.motZ *= (double)0.99f;
        }
        this.pitch = 0.0f;
        d2 = this.yaw;
        double d15 = this.lastX - this.locX;
        double d16 = this.lastZ - this.locZ;
        if (d15 * d15 + d16 * d16 > 0.001) {
            d2 = (float)(Math.atan2(d16, d15) * 180.0 / Math.PI);
        }
        if ((d = MathHelper.g(d2 - (double)this.yaw)) > 20.0) {
            d = 20.0;
        }
        if (d < -20.0) {
            d = -20.0;
        }
        this.yaw = (float)((double)this.yaw + d);
        this.b(this.yaw, this.pitch);
        if (this.world.isStatic) {
            return;
        }
        List list = this.world.getEntities(this, this.boundingBox.grow(0.2f, 0.0, 0.2f));
        if (list != null && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity == this.passenger || !entity.M() || !(entity instanceof EntityBoat)) continue;
                entity.collide(this);
            }
        }
        for (int i = 0; i < 4; ++i) {
            int n4 = MathHelper.floor(this.locX + ((double)(i % 2) - 0.5) * 0.8);
            int n5 = MathHelper.floor(this.locZ + ((double)(i / 2) - 0.5) * 0.8);
            for (int j = 0; j < 2; ++j) {
                int n6 = MathHelper.floor(this.locY) + j;
                int n7 = this.world.getTypeId(n4, n6, n5);
                int n8 = this.world.getData(n4, n6, n5);
                if (n7 == Block.SNOW.id) {
                    this.world.setTypeId(n4, n6, n5, 0);
                    continue;
                }
                if (n7 != Block.WATER_LILY.id) continue;
                Block.WATER_LILY.dropNaturally(this.world, n4, n6, n5, n8, 0.3f, 0);
                this.world.setTypeId(n4, n6, n5, 0);
            }
        }
        if (this.passenger != null && this.passenger.dead) {
            this.passenger = null;
        }
    }

    public void V() {
        if (this.passenger == null) {
            return;
        }
        double d = Math.cos((double)this.yaw * Math.PI / 180.0) * 0.4;
        double d2 = Math.sin((double)this.yaw * Math.PI / 180.0) * 0.4;
        this.passenger.setPosition(this.locX + d, this.locY + this.X() + this.passenger.W(), this.locZ + d2);
    }

    protected void b(NBTTagCompound nBTTagCompound) {
    }

    protected void a(NBTTagCompound nBTTagCompound) {
    }

    public boolean c(EntityHuman entityHuman) {
        if (this.passenger != null && this.passenger instanceof EntityHuman && this.passenger != entityHuman) {
            return true;
        }
        if (!this.world.isStatic) {
            entityHuman.mount(this);
        }
        return true;
    }

    public void setDamage(int n) {
        this.datawatcher.watch(19, n);
    }

    public int getDamage() {
        return this.datawatcher.getInt(19);
    }

    public void b(int n) {
        this.datawatcher.watch(17, n);
    }

    public int h() {
        return this.datawatcher.getInt(17);
    }

    public void c(int n) {
        this.datawatcher.watch(18, n);
    }

    public int i() {
        return this.datawatcher.getInt(18);
    }
}

