/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.ChatColor;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.GenericConnection;
import net.md_5.bungee.KickException;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.command.CommandSender;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet10HeldItem;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet46GameState;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketInputStream;

public class UserConnection
extends GenericConnection
implements CommandSender {
    public final Packet2Handshake handshake;
    public Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();
    private ServerConnection server;
    private UpstreamBridge upBridge;
    private DownstreamBridge downBridge;
    private Packet10HeldItem heldItem;
    private int clientEntityId;
    private int serverEntityId;

    public UserConnection(Socket socket, PacketInputStream in, OutputStream out, Packet2Handshake handshake) {
        super(socket, in, out);
        this.handshake = handshake;
        this.username = handshake.username;
        BungeeCord.instance.connections.put(this.username, this);
    }

    public void connect(String server) {
        InetSocketAddress addr = BungeeCord.instance.config.getServer(server);
        this.connect(server, addr);
    }

    private void connect(String name, InetSocketAddress serverAddr) {
        try {
            ServerConnection newServer = ServerConnection.connect(name, serverAddr, this.handshake, this.server == null);
            if (this.server == null) {
                this.clientEntityId = newServer.loginPacket.entityId;
                this.out.write(newServer.loginPacket.getPacket());
                this.upBridge = new UpstreamBridge();
                this.upBridge.start();
            } else {
                this.downBridge.alive = false;
                try {
                    this.downBridge.join();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.server.disconnect("Quitting");
                this.out.write(new Packet9Respawn(1, 0, 0, 256, "DEFAULT").getPacket());
                this.out.write(new Packet9Respawn(-1, 0, 0, 256, "DEFAULT").getPacket());
                Packet1Login login = newServer.loginPacket;
                this.serverEntityId = login.entityId;
                this.out.write(new Packet9Respawn(login.dimension, login.difficulty, login.gameMode, 256, login.levelType).getPacket());
                this.out.write(new Packet46GameState(2, 0).getPacket());
                if (this.heldItem != null) {
                    newServer.out.write(this.heldItem.getPacket());
                }
            }
            this.downBridge = new DownstreamBridge();
            this.server = newServer;
            this.downBridge.start();
        }
        catch (KickException ex) {
            this.destory(ex.getMessage());
        }
        catch (Exception ex) {
            if (this.server == null) {
                this.destory("Could not connect to server");
            }
            this.packetQueue.add(new Packet3Chat((Object)((Object)ChatColor.YELLOW) + "The server you selected is not up at the moment."));
        }
    }

    private void destory(String reason) {
        if (BungeeCord.instance.isRunning) {
            BungeeCord.instance.connections.remove(this.username);
        }
        this.disconnect(reason);
        if (this.server != null) {
            this.server.disconnect("Quitting");
            BungeeCord.instance.config.setServer(this, this.server.name);
        }
    }

    @Override
    public void sendMessage(String message) {
        this.packetQueue.add(new Packet3Chat(message));
    }

    private class DownstreamBridge
    extends Thread {
        private volatile boolean alive;

        public DownstreamBridge() {
            super("Downstream Bridge - " + UserConnection.this.username);
            this.alive = true;
        }

        @Override
        public void run() {
            try {
                while (this.alive) {
                    byte[] packet = ((UserConnection)UserConnection.this).server.in.readPacket();
                    boolean sendPacket = true;
                    int id = Util.getId(packet);
                    if (id == 250) {
                        PacketFAPluginMessage message = new PacketFAPluginMessage(packet);
                        if (message.tag.equals("RubberBand")) {
                            String server = new String(message.data);
                            UserConnection.this.connect(server);
                            sendPacket = false;
                        }
                    }
                    while (!UserConnection.this.packetQueue.isEmpty()) {
                        DefinedPacket p = UserConnection.this.packetQueue.poll();
                        if (p == null) continue;
                        UserConnection.this.out.write(p.getPacket());
                    }
                    EntityMap.rewrite(packet, UserConnection.this.serverEntityId, UserConnection.this.clientEntityId);
                    if (!sendPacket) continue;
                    UserConnection.this.out.write(packet);
                }
            }
            catch (IOException ex) {
            }
            catch (Exception ex) {
                UserConnection.this.destory(Util.exception(ex));
            }
        }
    }

    private class UpstreamBridge
    extends Thread {
        public UpstreamBridge() {
            super("Upstream Bridge - " + UserConnection.this.username);
        }

        @Override
        public void run() {
            while (!UserConnection.this.socket.isClosed()) {
                try {
                    byte[] packet = UserConnection.this.in.readPacket();
                    boolean sendPacket = true;
                    int id = Util.getId(packet);
                    if (id == 3) {
                        Packet3Chat chat = new Packet3Chat(packet);
                        String message = chat.message;
                        if (message.startsWith("/")) {
                            sendPacket = !BungeeCord.instance.dispatchCommand(message.substring(1), UserConnection.this);
                        }
                    } else if (id == 16) {
                        UserConnection.this.heldItem = new Packet10HeldItem(packet);
                    }
                    EntityMap.rewrite(packet, UserConnection.this.clientEntityId, UserConnection.this.serverEntityId);
                    if (!sendPacket || ((UserConnection)UserConnection.this).server.socket.isClosed()) continue;
                    ((UserConnection)UserConnection.this).server.out.write(packet);
                }
                catch (IOException ex) {
                    UserConnection.this.destory("Reached end of stream");
                }
                catch (Exception ex) {
                    UserConnection.this.destory(Util.exception(ex));
                }
            }
        }
    }
}

