/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.ExceptionWorldConflict;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IDataManager;
import net.minecraft.server.NBTCompressedStreamTools;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PlayerFileData;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldProvider;

public class WorldNBTStorage
implements IDataManager,
PlayerFileData {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final File baseDir;
    private final File playerDir;
    private final File dataDir;
    private final long sessionId = System.currentTimeMillis();
    private final String f;

    public WorldNBTStorage(File file, String string, boolean bl) {
        this.baseDir = new File(file, string);
        this.baseDir.mkdirs();
        this.playerDir = new File(this.baseDir, "players");
        this.dataDir = new File(this.baseDir, "data");
        this.dataDir.mkdirs();
        this.f = string;
        if (bl) {
            this.playerDir.mkdirs();
        }
        this.h();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void h() {
        try {
            File file = new File(this.baseDir, "session.lock");
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            try {
                dataOutputStream.writeLong(this.sessionId);
            }
            finally {
                dataOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    protected File getDirectory() {
        return this.baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSession() {
        try {
            File file = new File(this.baseDir, "session.lock");
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            try {
                if (dataInputStream.readLong() != this.sessionId) {
                    throw new ExceptionWorldConflict("The save is being accessed from another location, aborting");
                }
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ExceptionWorldConflict("Failed to check session lock, aborting");
        }
    }

    public IChunkLoader createChunkLoader(WorldProvider worldProvider) {
        throw new RuntimeException("Old Chunk Storage is no longer supported.");
    }

    public WorldData getWorldData() {
        File file = new File(this.baseDir, "level.dat");
        if (file.exists()) {
            try {
                NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.a(new FileInputStream(file));
                NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("Data");
                return new WorldData(nBTTagCompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file = new File(this.baseDir, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.a(new FileInputStream(file));
                NBTTagCompound nBTTagCompound3 = nBTTagCompound.getCompound("Data");
                return new WorldData(nBTTagCompound3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public void saveWorldData(WorldData worldData, NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = worldData.a(nBTTagCompound);
        NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
        nBTTagCompound3.set("Data", nBTTagCompound2);
        try {
            File file = new File(this.baseDir, "level.dat_new");
            File file2 = new File(this.baseDir, "level.dat_old");
            File file3 = new File(this.baseDir, "level.dat");
            NBTCompressedStreamTools.a(nBTTagCompound3, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveWorldData(WorldData worldData) {
        NBTTagCompound nBTTagCompound = worldData.a();
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        nBTTagCompound2.set("Data", nBTTagCompound);
        try {
            File file = new File(this.baseDir, "level.dat_new");
            File file2 = new File(this.baseDir, "level.dat_old");
            File file3 = new File(this.baseDir, "level.dat");
            NBTCompressedStreamTools.a(nBTTagCompound2, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save(EntityHuman entityHuman) {
        try {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            entityHuman.d(nBTTagCompound);
            File file = new File(this.playerDir, entityHuman.name + ".dat.tmp");
            File file2 = new File(this.playerDir, entityHuman.name + ".dat");
            NBTCompressedStreamTools.a(nBTTagCompound, new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        catch (Exception exception) {
            log.warning("Failed to save player data for " + entityHuman.name);
        }
    }

    public void load(EntityHuman entityHuman) {
        NBTTagCompound nBTTagCompound = this.getPlayerData(entityHuman.name);
        if (nBTTagCompound != null) {
            entityHuman.e(nBTTagCompound);
        }
    }

    public NBTTagCompound getPlayerData(String string) {
        try {
            File file = new File(this.playerDir, string + ".dat");
            if (file.exists()) {
                return NBTCompressedStreamTools.a(new FileInputStream(file));
            }
        }
        catch (Exception exception) {
            log.warning("Failed to load player data for " + string);
        }
        return null;
    }

    public PlayerFileData getPlayerFileData() {
        return this;
    }

    public String[] getSeenPlayers() {
        String[] stringArray = this.playerDir.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".dat")) continue;
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 4);
        }
        return stringArray;
    }

    public void a() {
    }

    public File getDataFile(String string) {
        return new File(this.dataDir, string + ".dat");
    }

    public String g() {
        return this.f;
    }
}

