/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BanEntry;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerMerchant;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.INetworkManager;
import net.minecraft.server.IntHashMap;
import net.minecraft.server.Item;
import net.minecraft.server.ItemBookAndQuill;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemWrittenBook;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.NetHandler;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet0KeepAlive;
import net.minecraft.server.Packet101CloseWindow;
import net.minecraft.server.Packet102WindowClick;
import net.minecraft.server.Packet103SetSlot;
import net.minecraft.server.Packet106Transaction;
import net.minecraft.server.Packet107SetCreativeSlot;
import net.minecraft.server.Packet108ButtonClick;
import net.minecraft.server.Packet10Flying;
import net.minecraft.server.Packet130UpdateSign;
import net.minecraft.server.Packet13PlayerLookMove;
import net.minecraft.server.Packet14BlockDig;
import net.minecraft.server.Packet15Place;
import net.minecraft.server.Packet16BlockItemSwitch;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet19EntityAction;
import net.minecraft.server.Packet202Abilities;
import net.minecraft.server.Packet203TabComplete;
import net.minecraft.server.Packet204LocaleAndViewDistance;
import net.minecraft.server.Packet205ClientCommand;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Packet255KickDisconnect;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet53BlockChange;
import net.minecraft.server.Packet7UseEntity;
import net.minecraft.server.Packet9Respawn;
import net.minecraft.server.PlayerInventory;
import net.minecraft.server.SharedConstants;
import net.minecraft.server.Slot;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntitySign;
import net.minecraft.server.WorldServer;

public class NetServerHandler
extends NetHandler {
    public static Logger logger = Logger.getLogger("Minecraft");
    public INetworkManager networkManager;
    public boolean disconnected = false;
    private MinecraftServer minecraftServer;
    private EntityPlayer player;
    private int f;
    private int g;
    private boolean h;
    private int i;
    private long j;
    private static Random k = new Random();
    private long l;
    private int m = 0;
    private int x = 0;
    private double y;
    private double z;
    private double q;
    private boolean checkMovement = true;
    private IntHashMap s = new IntHashMap();

    public NetServerHandler(MinecraftServer minecraftServer, INetworkManager iNetworkManager, EntityPlayer entityPlayer) {
        this.minecraftServer = minecraftServer;
        this.networkManager = iNetworkManager;
        iNetworkManager.a(this);
        this.player = entityPlayer;
        entityPlayer.netServerHandler = this;
    }

    public void d() {
        this.h = false;
        ++this.f;
        this.minecraftServer.methodProfiler.a("packetflow");
        this.networkManager.b();
        this.minecraftServer.methodProfiler.c("keepAlive");
        if ((long)this.f - this.l > 20L) {
            this.l = this.f;
            this.j = System.nanoTime() / 1000000L;
            this.i = k.nextInt();
            this.sendPacket(new Packet0KeepAlive(this.i));
        }
        if (this.m > 0) {
            --this.m;
        }
        if (this.x > 0) {
            --this.x;
        }
        this.minecraftServer.methodProfiler.c("playerTick");
        if (!this.h && !this.player.viewingCredits) {
            this.player.g();
            if (this.player.vehicle == null) {
                this.player.setPositionRotation(this.y, this.z, this.q, this.player.yaw, this.player.pitch);
            }
        }
        this.minecraftServer.methodProfiler.b();
    }

    public void disconnect(String string) {
        if (this.disconnected) {
            return;
        }
        this.player.m();
        this.sendPacket(new Packet255KickDisconnect(string));
        this.networkManager.d();
        this.minecraftServer.getServerConfigurationManager().sendAll(new Packet3Chat("\u00a7e" + this.player.name + " left the game."));
        this.minecraftServer.getServerConfigurationManager().disconnect(this.player);
        this.disconnected = true;
    }

    public void a(Packet10Flying packet10Flying) {
        double d;
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        this.h = true;
        if (this.player.viewingCredits) {
            return;
        }
        if (!this.checkMovement) {
            d = packet10Flying.y - this.z;
            if (packet10Flying.x == this.y && d * d < 0.01 && packet10Flying.z == this.q) {
                this.checkMovement = true;
            }
        }
        if (this.checkMovement) {
            double d2;
            double d3;
            double d4;
            if (this.player.vehicle != null) {
                float f = this.player.yaw;
                float f2 = this.player.pitch;
                this.player.vehicle.V();
                double d5 = this.player.locX;
                double d6 = this.player.locY;
                double d7 = this.player.locZ;
                double d8 = 0.0;
                double d9 = 0.0;
                if (packet10Flying.hasLook) {
                    f = packet10Flying.yaw;
                    f2 = packet10Flying.pitch;
                }
                if (packet10Flying.hasPos && packet10Flying.y == -999.0 && packet10Flying.stance == -999.0) {
                    if (Math.abs(packet10Flying.x) > 1.0 || Math.abs(packet10Flying.z) > 1.0) {
                        System.err.println(this.player.name + " was caught trying to crash the server with an invalid position.");
                        this.disconnect("Nope!");
                        return;
                    }
                    d8 = packet10Flying.x;
                    d9 = packet10Flying.z;
                }
                this.player.onGround = packet10Flying.g;
                this.player.g();
                this.player.move(d8, 0.0, d9);
                this.player.setLocation(d5, d6, d7, f, f2);
                this.player.motX = d8;
                this.player.motZ = d9;
                if (this.player.vehicle != null) {
                    worldServer.vehicleEnteredWorld(this.player.vehicle, true);
                }
                if (this.player.vehicle != null) {
                    this.player.vehicle.V();
                }
                this.minecraftServer.getServerConfigurationManager().d(this.player);
                this.y = this.player.locX;
                this.z = this.player.locY;
                this.q = this.player.locZ;
                worldServer.playerJoinedWorld(this.player);
                return;
            }
            if (this.player.isSleeping()) {
                this.player.g();
                this.player.setLocation(this.y, this.z, this.q, this.player.yaw, this.player.pitch);
                worldServer.playerJoinedWorld(this.player);
                return;
            }
            d = this.player.locY;
            this.y = this.player.locX;
            this.z = this.player.locY;
            this.q = this.player.locZ;
            double d10 = this.player.locX;
            double d11 = this.player.locY;
            double d12 = this.player.locZ;
            float f = this.player.yaw;
            float f3 = this.player.pitch;
            if (packet10Flying.hasPos && packet10Flying.y == -999.0 && packet10Flying.stance == -999.0) {
                packet10Flying.hasPos = false;
            }
            if (packet10Flying.hasPos) {
                d10 = packet10Flying.x;
                d11 = packet10Flying.y;
                d12 = packet10Flying.z;
                d4 = packet10Flying.stance - packet10Flying.y;
                if (!this.player.isSleeping() && (d4 > 1.65 || d4 < 0.1)) {
                    this.disconnect("Illegal stance");
                    logger.warning(this.player.name + " had an illegal stance: " + d4);
                    return;
                }
                if (Math.abs(packet10Flying.x) > 3.2E7 || Math.abs(packet10Flying.z) > 3.2E7) {
                    this.disconnect("Illegal position");
                    return;
                }
            }
            if (packet10Flying.hasLook) {
                f = packet10Flying.yaw;
                f3 = packet10Flying.pitch;
            }
            this.player.g();
            this.player.V = 0.0f;
            this.player.setLocation(this.y, this.z, this.q, f, f3);
            if (!this.checkMovement) {
                return;
            }
            d4 = d10 - this.player.locX;
            double d13 = d11 - this.player.locY;
            double d14 = d12 - this.player.locZ;
            double d15 = Math.min(Math.abs(d4), Math.abs(this.player.motX));
            double d16 = d15 * d15 + (d3 = Math.min(Math.abs(d13), Math.abs(this.player.motY))) * d3 + (d2 = Math.min(Math.abs(d14), Math.abs(this.player.motZ))) * d2;
            if (!(!(d16 > 100.0) || this.minecraftServer.H() && this.minecraftServer.G().equals(this.player.name))) {
                logger.warning(this.player.name + " moved too quickly! " + d4 + "," + d13 + "," + d14 + " (" + d15 + ", " + d3 + ", " + d2 + ")");
                this.a(this.y, this.z, this.q, this.player.yaw, this.player.pitch);
                return;
            }
            float f4 = 0.0625f;
            boolean bl = worldServer.getCubes(this.player, this.player.boundingBox.clone().shrink(f4, f4, f4)).isEmpty();
            if (this.player.onGround && !packet10Flying.g && d13 > 0.0) {
                this.player.j(0.2f);
            }
            this.player.move(d4, d13, d14);
            this.player.onGround = packet10Flying.g;
            this.player.checkMovement(d4, d13, d14);
            double d17 = d13;
            d4 = d10 - this.player.locX;
            d13 = d11 - this.player.locY;
            if (d13 > -0.5 || d13 < 0.5) {
                d13 = 0.0;
            }
            d14 = d12 - this.player.locZ;
            d16 = d4 * d4 + d13 * d13 + d14 * d14;
            boolean bl2 = false;
            if (d16 > 0.0625 && !this.player.isSleeping() && !this.player.itemInWorldManager.isCreative()) {
                bl2 = true;
                logger.warning(this.player.name + " moved wrongly!");
            }
            this.player.setLocation(d10, d11, d12, f, f3);
            boolean bl3 = worldServer.getCubes(this.player, this.player.boundingBox.clone().shrink(f4, f4, f4)).isEmpty();
            if (bl && (bl2 || !bl3) && !this.player.isSleeping()) {
                this.a(this.y, this.z, this.q, f, f3);
                return;
            }
            AxisAlignedBB axisAlignedBB = this.player.boundingBox.clone().grow(f4, f4, f4).a(0.0, -0.55, 0.0);
            if (!(this.minecraftServer.getAllowFlight() || this.player.itemInWorldManager.isCreative() || worldServer.c(axisAlignedBB))) {
                if (d17 >= -0.03125) {
                    ++this.g;
                    if (this.g > 80) {
                        logger.warning(this.player.name + " was kicked for floating too long!");
                        this.disconnect("Flying is not enabled on this server");
                        return;
                    }
                }
            } else {
                this.g = 0;
            }
            this.player.onGround = packet10Flying.g;
            this.minecraftServer.getServerConfigurationManager().d(this.player);
            this.player.b(this.player.locY - d, packet10Flying.g);
        }
    }

    public void a(double d, double d2, double d3, float f, float f2) {
        this.checkMovement = false;
        this.y = d;
        this.z = d2;
        this.q = d3;
        this.player.setLocation(d, d2, d3, f, f2);
        this.player.netServerHandler.sendPacket(new Packet13PlayerLookMove(d, d2 + (double)1.62f, d2, d3, f, f2, false));
    }

    public void a(Packet14BlockDig packet14BlockDig) {
        double d;
        double d2;
        double d3;
        double d4;
        int n;
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        if (packet14BlockDig.e == 4) {
            this.player.bB();
            return;
        }
        if (packet14BlockDig.e == 5) {
            this.player.by();
            return;
        }
        worldServer.weirdIsOpCache = worldServer.worldProvider.dimension != 0 || this.minecraftServer.getServerConfigurationManager().isOp(this.player.name) || this.minecraftServer.H();
        boolean bl = worldServer.weirdIsOpCache;
        boolean bl2 = false;
        if (packet14BlockDig.e == 0) {
            bl2 = true;
        }
        if (packet14BlockDig.e == 2) {
            bl2 = true;
        }
        int n2 = packet14BlockDig.a;
        int n3 = packet14BlockDig.b;
        int n4 = packet14BlockDig.c;
        if (bl2) {
            double d5 = this.player.locX - ((double)n2 + 0.5);
            double d6 = this.player.locY - ((double)n3 + 0.5) + 1.5;
            double d7 = this.player.locZ - ((double)n4 + 0.5);
            double d8 = d5 * d5 + d6 * d6 + d7 * d7;
            if (d8 > 36.0) {
                return;
            }
            if (n3 >= this.minecraftServer.getMaxBuildHeight()) {
                return;
            }
        }
        ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
        int n5 = MathHelper.a(n2 - chunkCoordinates.x);
        if (n5 > (n = MathHelper.a(n4 - chunkCoordinates.z))) {
            n = n5;
        }
        if (packet14BlockDig.e == 0) {
            if (n > 16 || bl) {
                this.player.itemInWorldManager.dig(n2, n3, n4, packet14BlockDig.face);
            } else {
                this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
            }
        } else if (packet14BlockDig.e == 2) {
            this.player.itemInWorldManager.a(n2, n3, n4);
            if (worldServer.getTypeId(n2, n3, n4) != 0) {
                this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
            }
        } else if (packet14BlockDig.e == 1) {
            this.player.itemInWorldManager.c(n2, n3, n4);
            if (worldServer.getTypeId(n2, n3, n4) != 0) {
                this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
            }
        } else if (packet14BlockDig.e == 3 && (d4 = (d3 = this.player.locX - ((double)n2 + 0.5)) * d3 + (d2 = this.player.locY - ((double)n3 + 0.5)) * d2 + (d = this.player.locZ - ((double)n4 + 0.5)) * d) < 256.0) {
            this.player.netServerHandler.sendPacket(new Packet53BlockChange(n2, n3, n4, worldServer));
        }
        worldServer.weirdIsOpCache = false;
    }

    public void a(Packet15Place packet15Place) {
        Object object;
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        ItemStack itemStack = this.player.inventory.getItemInHand();
        boolean bl = false;
        int n = packet15Place.d();
        int n2 = packet15Place.f();
        int n3 = packet15Place.g();
        int n4 = packet15Place.getFace();
        worldServer.weirdIsOpCache = worldServer.worldProvider.dimension != 0 || this.minecraftServer.getServerConfigurationManager().isOp(this.player.name) || this.minecraftServer.H();
        boolean bl2 = worldServer.weirdIsOpCache;
        if (packet15Place.getFace() == 255) {
            if (itemStack == null) {
                return;
            }
            this.player.itemInWorldManager.useItem(this.player, worldServer, itemStack);
        } else if (packet15Place.f() < this.minecraftServer.getMaxBuildHeight() - 1 || packet15Place.getFace() != 1 && packet15Place.f() < this.minecraftServer.getMaxBuildHeight()) {
            int n5;
            object = worldServer.getSpawn();
            int n6 = MathHelper.a(n - ((ChunkCoordinates)object).x);
            if (n6 > (n5 = MathHelper.a(n3 - ((ChunkCoordinates)object).z))) {
                n5 = n6;
            }
            if (this.checkMovement && this.player.e((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5) < 64.0 && (n5 > 16 || bl2)) {
                this.player.itemInWorldManager.interact(this.player, worldServer, itemStack, n, n2, n3, n4, packet15Place.j(), packet15Place.l(), packet15Place.m());
            }
            bl = true;
        } else {
            this.player.netServerHandler.sendPacket(new Packet3Chat("\u00a77Height limit for building is " + this.minecraftServer.getMaxBuildHeight()));
            bl = true;
        }
        if (bl) {
            this.player.netServerHandler.sendPacket(new Packet53BlockChange(n, n2, n3, worldServer));
            if (n4 == 0) {
                --n2;
            }
            if (n4 == 1) {
                ++n2;
            }
            if (n4 == 2) {
                --n3;
            }
            if (n4 == 3) {
                ++n3;
            }
            if (n4 == 4) {
                --n;
            }
            if (n4 == 5) {
                ++n;
            }
            this.player.netServerHandler.sendPacket(new Packet53BlockChange(n, n2, n3, worldServer));
        }
        if ((itemStack = this.player.inventory.getItemInHand()) != null && itemStack.count == 0) {
            this.player.inventory.items[this.player.inventory.itemInHandIndex] = null;
            itemStack = null;
        }
        if (itemStack == null || itemStack.m() == 0) {
            this.player.h = true;
            this.player.inventory.items[this.player.inventory.itemInHandIndex] = ItemStack.b(this.player.inventory.items[this.player.inventory.itemInHandIndex]);
            object = this.player.activeContainer.a(this.player.inventory, this.player.inventory.itemInHandIndex);
            this.player.activeContainer.b();
            this.player.h = false;
            if (!ItemStack.matches(this.player.inventory.getItemInHand(), packet15Place.getItemStack())) {
                this.sendPacket(new Packet103SetSlot(this.player.activeContainer.windowId, ((Slot)object).d, this.player.inventory.getItemInHand()));
            }
        }
        worldServer.weirdIsOpCache = false;
    }

    public void a(String string, Object[] objectArray) {
        logger.info(this.player.name + " lost connection: " + string);
        this.minecraftServer.getServerConfigurationManager().sendAll(new Packet3Chat("\u00a7e" + this.player.name + " left the game."));
        this.minecraftServer.getServerConfigurationManager().disconnect(this.player);
        this.disconnected = true;
        if (this.minecraftServer.H() && this.player.name.equals(this.minecraftServer.G())) {
            logger.info("Stopping singleplayer server as player logged out");
            this.minecraftServer.safeShutdown();
        }
    }

    public void onUnhandledPacket(Packet packet) {
        logger.warning(this.getClass() + " wasn't prepared to deal with a " + packet.getClass());
        this.disconnect("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        if (packet instanceof Packet3Chat) {
            Packet3Chat packet3Chat = (Packet3Chat)packet;
            int n = this.player.getChatFlags();
            if (n == 2) {
                return;
            }
            if (n == 1 && !packet3Chat.isServer()) {
                return;
            }
        }
        this.networkManager.queue(packet);
    }

    public void a(Packet16BlockItemSwitch packet16BlockItemSwitch) {
        if (packet16BlockItemSwitch.itemInHandIndex < 0 || packet16BlockItemSwitch.itemInHandIndex >= PlayerInventory.getHotbarSize()) {
            logger.warning(this.player.name + " tried to set an invalid carried item");
            return;
        }
        this.player.inventory.itemInHandIndex = packet16BlockItemSwitch.itemInHandIndex;
    }

    public void a(Packet3Chat packet3Chat) {
        if (this.player.getChatFlags() == 2) {
            this.sendPacket(new Packet3Chat("Cannot send chat message."));
            return;
        }
        String string = packet3Chat.message;
        if (string.length() > 100) {
            this.disconnect("Chat message too long");
            return;
        }
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            if (SharedConstants.isAllowedChatCharacter(string.charAt(i))) continue;
            this.disconnect("Illegal characters in chat");
            return;
        }
        if (string.startsWith("/")) {
            this.handleCommand(string);
        } else {
            if (this.player.getChatFlags() == 1) {
                this.sendPacket(new Packet3Chat("Cannot send chat message."));
                return;
            }
            string = "<" + this.player.name + "> " + string;
            logger.info(string);
            this.minecraftServer.getServerConfigurationManager().sendAll(new Packet3Chat(string, false));
        }
        this.m += 20;
        if (this.m > 200 && !this.minecraftServer.getServerConfigurationManager().isOp(this.player.name)) {
            this.disconnect("disconnect.spam");
        }
    }

    private void handleCommand(String string) {
        this.minecraftServer.getCommandHandler().a(this.player, string);
    }

    public void a(Packet18ArmAnimation packet18ArmAnimation) {
        if (packet18ArmAnimation.b == 1) {
            this.player.i();
        }
    }

    public void a(Packet19EntityAction packet19EntityAction) {
        if (packet19EntityAction.animation == 1) {
            this.player.setSneaking(true);
        } else if (packet19EntityAction.animation == 2) {
            this.player.setSneaking(false);
        } else if (packet19EntityAction.animation == 4) {
            this.player.setSprinting(true);
        } else if (packet19EntityAction.animation == 5) {
            this.player.setSprinting(false);
        } else if (packet19EntityAction.animation == 3) {
            this.player.a(false, true, true);
            this.checkMovement = false;
        }
    }

    public void a(Packet255KickDisconnect packet255KickDisconnect) {
        this.networkManager.a("disconnect.quitting", new Object[0]);
    }

    public int lowPriorityCount() {
        return this.networkManager.e();
    }

    public void a(Packet7UseEntity packet7UseEntity) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        Entity entity = worldServer.getEntity(packet7UseEntity.target);
        if (entity != null) {
            boolean bl = this.player.l(entity);
            double d = 36.0;
            if (!bl) {
                d = 9.0;
            }
            if (this.player.e(entity) < d) {
                if (packet7UseEntity.action == 0) {
                    this.player.m(entity);
                } else if (packet7UseEntity.action == 1) {
                    this.player.attack(entity);
                }
            }
        }
    }

    public void a(Packet205ClientCommand packet205ClientCommand) {
        if (packet205ClientCommand.a == 1) {
            if (this.player.viewingCredits) {
                this.player = this.minecraftServer.getServerConfigurationManager().moveToWorld(this.player, 0, true);
            } else if (this.player.q().getWorldData().isHardcore()) {
                if (this.minecraftServer.H() && this.player.name.equals(this.minecraftServer.G())) {
                    this.player.netServerHandler.disconnect("You have died. Game over, man, it's game over!");
                    this.minecraftServer.O();
                } else {
                    BanEntry banEntry = new BanEntry(this.player.name);
                    banEntry.setReason("Death in Hardcore");
                    this.minecraftServer.getServerConfigurationManager().getNameBans().add(banEntry);
                    this.player.netServerHandler.disconnect("You have died. Game over, man, it's game over!");
                }
            } else {
                if (this.player.getHealth() > 0) {
                    return;
                }
                this.player = this.minecraftServer.getServerConfigurationManager().moveToWorld(this.player, 0, false);
            }
        }
    }

    public boolean b() {
        return true;
    }

    public void a(Packet9Respawn packet9Respawn) {
    }

    public void handleContainerClose(Packet101CloseWindow packet101CloseWindow) {
        this.player.l();
    }

    public void a(Packet102WindowClick packet102WindowClick) {
        if (this.player.activeContainer.windowId == packet102WindowClick.a && this.player.activeContainer.b(this.player)) {
            ItemStack itemStack = this.player.activeContainer.clickItem(packet102WindowClick.slot, packet102WindowClick.button, packet102WindowClick.shift, this.player);
            if (ItemStack.matches(packet102WindowClick.item, itemStack)) {
                this.player.netServerHandler.sendPacket(new Packet106Transaction(packet102WindowClick.a, packet102WindowClick.d, true));
                this.player.h = true;
                this.player.activeContainer.b();
                this.player.broadcastCarriedItem();
                this.player.h = false;
            } else {
                this.s.a(this.player.activeContainer.windowId, packet102WindowClick.d);
                this.player.netServerHandler.sendPacket(new Packet106Transaction(packet102WindowClick.a, packet102WindowClick.d, false));
                this.player.activeContainer.a((EntityHuman)this.player, false);
                ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
                for (int i = 0; i < this.player.activeContainer.b.size(); ++i) {
                    arrayList.add(((Slot)this.player.activeContainer.b.get(i)).getItem());
                }
                this.player.a(this.player.activeContainer, arrayList);
            }
        }
    }

    public void a(Packet108ButtonClick packet108ButtonClick) {
        if (this.player.activeContainer.windowId == packet108ButtonClick.a && this.player.activeContainer.b(this.player)) {
            this.player.activeContainer.a((EntityHuman)this.player, packet108ButtonClick.b);
            this.player.activeContainer.b();
        }
    }

    public void a(Packet107SetCreativeSlot packet107SetCreativeSlot) {
        if (this.player.itemInWorldManager.isCreative()) {
            boolean bl;
            boolean bl2 = packet107SetCreativeSlot.slot < 0;
            ItemStack itemStack = packet107SetCreativeSlot.b;
            boolean bl3 = packet107SetCreativeSlot.slot >= 1 && packet107SetCreativeSlot.slot < 36 + PlayerInventory.getHotbarSize();
            boolean bl4 = itemStack == null || itemStack.id < Item.byId.length && itemStack.id >= 0 && Item.byId[itemStack.id] != null;
            boolean bl5 = bl = itemStack == null || itemStack.getData() >= 0 && itemStack.getData() >= 0 && itemStack.count <= 64 && itemStack.count > 0;
            if (bl3 && bl4 && bl) {
                if (itemStack == null) {
                    this.player.defaultContainer.setItem(packet107SetCreativeSlot.slot, null);
                } else {
                    this.player.defaultContainer.setItem(packet107SetCreativeSlot.slot, itemStack);
                }
                this.player.defaultContainer.a((EntityHuman)this.player, true);
            } else if (bl2 && bl4 && bl && this.x < 200) {
                this.x += 20;
                EntityItem entityItem = this.player.drop(itemStack);
                if (entityItem != null) {
                    entityItem.d();
                }
            }
        }
    }

    public void a(Packet106Transaction packet106Transaction) {
        Short s = (Short)this.s.get(this.player.activeContainer.windowId);
        if (s != null && packet106Transaction.b == s && this.player.activeContainer.windowId == packet106Transaction.a && !this.player.activeContainer.b(this.player)) {
            this.player.activeContainer.a((EntityHuman)this.player, true);
        }
    }

    public void a(Packet130UpdateSign packet130UpdateSign) {
        WorldServer worldServer = this.minecraftServer.getWorldServer(this.player.dimension);
        if (worldServer.isLoaded(packet130UpdateSign.x, packet130UpdateSign.y, packet130UpdateSign.z)) {
            int n;
            int n2;
            int n3;
            TileEntitySign tileEntitySign;
            TileEntity tileEntity = worldServer.getTileEntity(packet130UpdateSign.x, packet130UpdateSign.y, packet130UpdateSign.z);
            if (tileEntity instanceof TileEntitySign && !(tileEntitySign = (TileEntitySign)tileEntity).a()) {
                this.minecraftServer.warning("Player " + this.player.name + " just tried to change non-editable sign");
                return;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = 1;
                if (packet130UpdateSign.lines[n3].length() > 15) {
                    n2 = 0;
                } else {
                    for (n = 0; n < packet130UpdateSign.lines[n3].length(); ++n) {
                        if (SharedConstants.allowedCharacters.indexOf(packet130UpdateSign.lines[n3].charAt(n)) >= 0) continue;
                        n2 = 0;
                    }
                }
                if (n2 != 0) continue;
                packet130UpdateSign.lines[n3] = "!?";
            }
            if (tileEntity instanceof TileEntitySign) {
                n3 = packet130UpdateSign.x;
                n2 = packet130UpdateSign.y;
                n = packet130UpdateSign.z;
                TileEntitySign tileEntitySign2 = (TileEntitySign)tileEntity;
                System.arraycopy(packet130UpdateSign.lines, 0, tileEntitySign2.lines, 0, 4);
                tileEntitySign2.update();
                worldServer.notify(n3, n2, n);
            }
        }
    }

    public void a(Packet0KeepAlive packet0KeepAlive) {
        if (packet0KeepAlive.a == this.i) {
            int n = (int)(System.nanoTime() / 1000000L - this.j);
            this.player.ping = (this.player.ping * 3 + n) / 4;
        }
    }

    public boolean a() {
        return true;
    }

    public void a(Packet202Abilities packet202Abilities) {
        this.player.abilities.isFlying = packet202Abilities.f() && this.player.abilities.canFly;
    }

    public void a(Packet203TabComplete packet203TabComplete) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.minecraftServer.a(this.player, packet203TabComplete.d())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\u0000");
            }
            stringBuilder.append(string);
        }
        this.player.netServerHandler.sendPacket(new Packet203TabComplete(stringBuilder.toString()));
    }

    public void a(Packet204LocaleAndViewDistance packet204LocaleAndViewDistance) {
        this.player.a(packet204LocaleAndViewDistance);
    }

    public void a(Packet250CustomPayload packet250CustomPayload) {
        if ("MC|BEdit".equals(packet250CustomPayload.tag)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                ItemStack itemStack = Packet.c(dataInputStream);
                if (!ItemBookAndQuill.a(itemStack.getTag())) {
                    throw new IOException("Invalid book tag!");
                }
                ItemStack itemStack2 = this.player.inventory.getItemInHand();
                if (itemStack != null && itemStack.id == Item.BOOK_AND_QUILL.id && itemStack.id == itemStack2.id) {
                    itemStack2.setTag(itemStack.getTag());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("MC|BSign".equals(packet250CustomPayload.tag)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                ItemStack itemStack = Packet.c(dataInputStream);
                if (!ItemWrittenBook.a(itemStack.getTag())) {
                    throw new IOException("Invalid book tag!");
                }
                ItemStack itemStack3 = this.player.inventory.getItemInHand();
                if (itemStack != null && itemStack.id == Item.WRITTEN_BOOK.id && itemStack3.id == Item.BOOK_AND_QUILL.id) {
                    itemStack3.setTag(itemStack.getTag());
                    itemStack3.id = Item.WRITTEN_BOOK.id;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("MC|TrSel".equals(packet250CustomPayload.tag)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(packet250CustomPayload.data));
                int n = dataInputStream.readInt();
                Container container = this.player.activeContainer;
                if (container instanceof ContainerMerchant) {
                    ((ContainerMerchant)container).c(n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

