/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.DamageSource;
import net.minecraft.server.EnchantmentArrowDamage;
import net.minecraft.server.EnchantmentArrowKnockback;
import net.minecraft.server.EnchantmentDigging;
import net.minecraft.server.EnchantmentDurability;
import net.minecraft.server.EnchantmentFire;
import net.minecraft.server.EnchantmentFlameArrows;
import net.minecraft.server.EnchantmentInfiniteArrows;
import net.minecraft.server.EnchantmentKnockback;
import net.minecraft.server.EnchantmentLootBonus;
import net.minecraft.server.EnchantmentOxygen;
import net.minecraft.server.EnchantmentProtection;
import net.minecraft.server.EnchantmentSilkTouch;
import net.minecraft.server.EnchantmentSlotType;
import net.minecraft.server.EnchantmentWaterWorker;
import net.minecraft.server.EnchantmentWeaponDamage;
import net.minecraft.server.EntityLiving;

public abstract class Enchantment {
    public static final Enchantment[] byId = new Enchantment[256];
    public static final Enchantment PROTECTION_ENVIRONMENTAL = new EnchantmentProtection(0, 10, 0);
    public static final Enchantment PROTECTION_FIRE = new EnchantmentProtection(1, 5, 1);
    public static final Enchantment PROTECTION_FALL = new EnchantmentProtection(2, 5, 2);
    public static final Enchantment PROTECTION_EXPLOSIONS = new EnchantmentProtection(3, 2, 3);
    public static final Enchantment PROTECTION_PROJECTILE = new EnchantmentProtection(4, 5, 4);
    public static final Enchantment OXYGEN = new EnchantmentOxygen(5, 2);
    public static final Enchantment WATER_WORKER = new EnchantmentWaterWorker(6, 2);
    public static final Enchantment DAMAGE_ALL = new EnchantmentWeaponDamage(16, 10, 0);
    public static final Enchantment DAMAGE_UNDEAD = new EnchantmentWeaponDamage(17, 5, 1);
    public static final Enchantment DAMAGE_ARTHROPODS = new EnchantmentWeaponDamage(18, 5, 2);
    public static final Enchantment KNOCKBACK = new EnchantmentKnockback(19, 5);
    public static final Enchantment FIRE_ASPECT = new EnchantmentFire(20, 2);
    public static final Enchantment LOOT_BONUS_MOBS = new EnchantmentLootBonus(21, 2, EnchantmentSlotType.WEAPON);
    public static final Enchantment DIG_SPEED = new EnchantmentDigging(32, 10);
    public static final Enchantment SILK_TOUCH = new EnchantmentSilkTouch(33, 1);
    public static final Enchantment DURABILITY = new EnchantmentDurability(34, 5);
    public static final Enchantment LOOT_BONUS_BLOCKS = new EnchantmentLootBonus(35, 2, EnchantmentSlotType.DIGGER);
    public static final Enchantment ARROW_DAMAGE = new EnchantmentArrowDamage(48, 10);
    public static final Enchantment ARROW_KNOCKBACK = new EnchantmentArrowKnockback(49, 2);
    public static final Enchantment ARROW_FIRE = new EnchantmentFlameArrows(50, 2);
    public static final Enchantment ARROW_INFINITE = new EnchantmentInfiniteArrows(51, 1);
    public final int id;
    private final int weight;
    public EnchantmentSlotType slot;
    protected String name;

    protected Enchantment(int n, int n2, EnchantmentSlotType enchantmentSlotType) {
        this.id = n;
        this.weight = n2;
        this.slot = enchantmentSlotType;
        if (byId[n] != null) {
            throw new IllegalArgumentException("Duplicate enchantment id!");
        }
        Enchantment.byId[n] = this;
    }

    public int getRandomWeight() {
        return this.weight;
    }

    public int getStartLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int a(int n) {
        return 1 + n * 10;
    }

    public int b(int n) {
        return this.a(n) + 5;
    }

    public int a(int n, DamageSource damageSource) {
        return 0;
    }

    public int a(int n, EntityLiving entityLiving) {
        return 0;
    }

    public boolean a(Enchantment enchantment) {
        return this != enchantment;
    }

    public Enchantment b(String string) {
        this.name = string;
        return this;
    }
}

