/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.panels;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.spigotmc.gui.Theme;
import org.spigotmc.gui.attributes.Themeable;
import org.spigotmc.gui.data.ThemePack;
import org.spigotmc.utils.SwingUtils;

public class ThemeSwitcherPanel
extends JPanel
implements Themeable {
    private Theme currentTheme = Theme.LIGHT;
    private final JFrame parent;
    private JButton lightButton;
    private JButton darkButton;

    public ThemeSwitcherPanel(JFrame parent) {
        this.parent = parent;
        this.setLayout(new FlowLayout(1, 2, 2));
        this.initComponents();
    }

    private void initComponents() {
        this.lightButton = new JButton();
        this.lightButton.setBackground(new Color(222, 222, 222));
        this.lightButton.setToolTipText("Switch to the light theme.");
        this.lightButton.setBorderPainted(false);
        this.lightButton.setMargin(new Insets(4, 12, 4, 12));
        this.lightButton.addActionListener(this::lightModeSwitch);
        this.lightButton.setCursor(Cursor.getPredefinedCursor(12));
        this.lightButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (ThemeSwitcherPanel.this.currentTheme == Theme.DARK) {
                    ThemeSwitcherPanel.this.lightButton.setContentAreaFilled(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                if (ThemeSwitcherPanel.this.currentTheme == Theme.DARK) {
                    ThemeSwitcherPanel.this.lightButton.setContentAreaFilled(false);
                }
            }
        });
        this.darkButton = new JButton();
        this.darkButton.setToolTipText("Switch to the dark theme.");
        this.darkButton.setBackground(new Color(222, 222, 222));
        this.darkButton.setBorderPainted(false);
        this.darkButton.setContentAreaFilled(false);
        this.darkButton.setMargin(new Insets(4, 12, 4, 12));
        this.darkButton.addActionListener(this::darkModeSwitch);
        this.darkButton.setCursor(Cursor.getPredefinedCursor(12));
        this.darkButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (ThemeSwitcherPanel.this.currentTheme == Theme.LIGHT) {
                    ThemeSwitcherPanel.this.darkButton.setContentAreaFilled(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                if (ThemeSwitcherPanel.this.currentTheme == Theme.LIGHT) {
                    ThemeSwitcherPanel.this.darkButton.setContentAreaFilled(false);
                }
            }
        });
        this.add(this.lightButton);
        this.add(this.darkButton);
    }

    private void lightModeSwitch(ActionEvent event) {
        if (this.currentTheme == Theme.LIGHT) {
            return;
        }
        FlatLightLaf.setup();
        this.lightButton.setContentAreaFilled(true);
        this.darkButton.setContentAreaFilled(false);
        this.lightButton.setBackground(new Color(222, 222, 222));
        this.darkButton.setBackground(new Color(222, 222, 222));
        SwingUtils.changeTheme(this.parent, Theme.LIGHT);
        FlatLaf.updateUI();
        this.currentTheme = Theme.LIGHT;
    }

    private void darkModeSwitch(ActionEvent event) {
        if (this.currentTheme == Theme.DARK) {
            return;
        }
        FlatDarkLaf.setup();
        this.lightButton.setContentAreaFilled(false);
        this.darkButton.setContentAreaFilled(true);
        this.lightButton.setBackground(new Color(70, 73, 75));
        this.darkButton.setBackground(new Color(70, 73, 75));
        SwingUtils.changeTheme(this.parent, Theme.DARK);
        FlatLaf.updateUI();
        this.currentTheme = Theme.DARK;
    }

    @Override
    public void onThemeChange(Theme theme) {
        ThemePack pack = ThemePack.fromTheme(theme);
        Color borderColor = (Color)pack.getAsset(ThemePack.Asset.BORDER_COLOR);
        this.setBorder(BorderFactory.createLineBorder(borderColor, 1, true));
        ImageIcon sun = (ImageIcon)pack.getAsset(ThemePack.Asset.SUN);
        this.lightButton.setIcon(sun);
        ImageIcon moon = (ImageIcon)pack.getAsset(ThemePack.Asset.MOON);
        this.darkButton.setIcon(moon);
    }
}

