/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DurationFormatUtils {
    static String format(Token[] tokens, long years, long months, long days, long hours, long minutes, long seconds, long milliseconds, boolean padWithZeros) {
        StringBuilder buffer = new StringBuilder();
        boolean lastOutputSeconds = false;
        boolean lastOutputZero = false;
        int optionalStart = -1;
        boolean firstOptionalNonLiteral = false;
        int optionalIndex = -1;
        boolean inOptional = false;
        for (Token token : tokens) {
            Object value = token.getValue();
            boolean isLiteral = value instanceof StringBuilder;
            int count = token.getCount();
            if (optionalIndex != token.optionalIndex) {
                optionalIndex = token.optionalIndex;
                if (optionalIndex > -1) {
                    optionalStart = buffer.length();
                    lastOutputZero = false;
                    inOptional = true;
                    firstOptionalNonLiteral = false;
                } else {
                    inOptional = false;
                }
            }
            if (isLiteral) {
                if (!inOptional || !lastOutputZero) {
                    buffer.append(value.toString());
                }
            } else if (value.equals("y")) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = years == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(years, padWithZeros, count));
                }
            } else if (value.equals("M")) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = months == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(months, padWithZeros, count));
                }
            } else if (value.equals("d")) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = days == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(days, padWithZeros, count));
                }
            } else if (value.equals("H")) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = hours == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(hours, padWithZeros, count));
                }
            } else if (value.equals("m")) {
                lastOutputSeconds = false;
                boolean bl = lastOutputZero = minutes == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(minutes, padWithZeros, count));
                }
            } else if (value.equals("s")) {
                lastOutputSeconds = true;
                boolean bl = lastOutputZero = seconds == 0L;
                if (!inOptional || !lastOutputZero) {
                    buffer.append(DurationFormatUtils.paddedValue(seconds, padWithZeros, count));
                }
            } else if (value.equals("S")) {
                boolean bl = lastOutputZero = milliseconds == 0L;
                if (!inOptional || !lastOutputZero) {
                    if (lastOutputSeconds) {
                        int width = padWithZeros ? Math.max(3, count) : 3;
                        buffer.append(DurationFormatUtils.paddedValue(milliseconds, true, width));
                    } else {
                        buffer.append(DurationFormatUtils.paddedValue(milliseconds, padWithZeros, count));
                    }
                }
                lastOutputSeconds = false;
            }
            if (!inOptional || isLiteral || firstOptionalNonLiteral) continue;
            firstOptionalNonLiteral = true;
            if (!lastOutputZero) continue;
            buffer.delete(optionalStart, buffer.length());
        }
        return buffer.toString();
    }

    public static String formatDuration(long durationMillis, String format) {
        return DurationFormatUtils.formatDuration(durationMillis, format, true);
    }

    public static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Validate.inclusiveBetween(0L, Long.MAX_VALUE, durationMillis, "durationMillis must not be negative");
        Token[] tokens = DurationFormatUtils.lexx(format);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long milliseconds = durationMillis;
        if (Token.containsTokenWithValue(tokens, "d")) {
            days = milliseconds / 86400000L;
            milliseconds -= days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, "H")) {
            hours = milliseconds / 3600000L;
            milliseconds -= hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, "m")) {
            minutes = milliseconds / 60000L;
            milliseconds -= minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, "s")) {
            seconds = milliseconds / 1000L;
            milliseconds -= seconds * 1000L;
        }
        return DurationFormatUtils.format(tokens, 0L, 0L, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String tmp;
        String duration = DurationFormatUtils.formatDuration(durationMillis, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (suppressLeadingZeroElements) {
            duration = " " + duration;
            tmp = StringUtils.replaceOnce(duration, " 0 days", "");
            if (tmp.length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
                duration = tmp;
                duration = tmp = StringUtils.replaceOnce(duration, " 0 minutes", "");
            }
            if (!duration.isEmpty()) {
                duration = duration.substring(1);
            }
        }
        if (suppressTrailingZeroElements && (tmp = StringUtils.replaceOnce(duration, " 0 seconds", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 minutes", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
            duration = StringUtils.replaceOnce(tmp, " 0 days", "");
        }
        duration = " " + duration;
        duration = StringUtils.replaceOnce(duration, " 1 seconds", " 1 second");
        duration = StringUtils.replaceOnce(duration, " 1 minutes", " 1 minute");
        duration = StringUtils.replaceOnce(duration, " 1 hours", " 1 hour");
        duration = StringUtils.replaceOnce(duration, " 1 days", " 1 day");
        return duration.trim();
    }

    static Token[] lexx(String format) {
        ArrayList<Token> list = new ArrayList<Token>(format.length());
        boolean inLiteral = false;
        StringBuilder buffer = null;
        Token previous = null;
        boolean inOptional = false;
        int optionalIndex = -1;
        for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            String value = null;
            switch (ch) {
                case '[': {
                    if (inOptional) {
                        throw new IllegalArgumentException("Nested optional block at index: " + i);
                    }
                    ++optionalIndex;
                    inOptional = true;
                    break;
                }
                case ']': {
                    if (!inOptional) {
                        throw new IllegalArgumentException("Attempting to close unopened optional block at index: " + i);
                    }
                    inOptional = false;
                    break;
                }
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuilder();
                    list.add(new Token(buffer, inOptional, optionalIndex));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value = "y";
                    break;
                }
                case 'M': {
                    value = "M";
                    break;
                }
                case 'd': {
                    value = "d";
                    break;
                }
                case 'H': {
                    value = "H";
                    break;
                }
                case 'm': {
                    value = "m";
                    break;
                }
                case 's': {
                    value = "s";
                    break;
                }
                case 'S': {
                    value = "S";
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                        list.add(new Token(buffer, inOptional, optionalIndex));
                    }
                    buffer.append(ch);
                }
            }
            if (value == null) continue;
            if (previous != null && previous.getValue().equals(value)) {
                previous.increment();
            } else {
                Token token = new Token(value, inOptional, optionalIndex);
                list.add(token);
                previous = token;
            }
            buffer = null;
        }
        if (inLiteral) {
            throw new IllegalArgumentException("Unmatched quote in format: " + format);
        }
        if (inOptional) {
            throw new IllegalArgumentException("Unmatched optional in format: " + format);
        }
        return list.toArray(Token.EMPTY_ARRAY);
    }

    private static String paddedValue(long value, boolean padWithZeros, int count) {
        String longString = Long.toString(value);
        return padWithZeros ? StringUtils.leftPad(longString, count, '0') : longString;
    }

    static class Token {
        private static final Token[] EMPTY_ARRAY = new Token[0];
        private final Object value;
        private int count;
        private int optionalIndex = -1;

        static boolean containsTokenWithValue(Token[] tokens, Object value) {
            return Stream.of(tokens).anyMatch(token -> token.getValue() == value);
        }

        Token(Object value, boolean optional, int optionalIndex) {
            this.value = Objects.requireNonNull(value, "value");
            this.count = 1;
            if (optional) {
                this.optionalIndex = optionalIndex;
            }
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

