/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.data;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public final class BuildSettings {
    private String version = "";
    private String finalName = "";
    private String outputDirectory = "";
    private String spigotPrId = "";
    private String craftbukkitPrId = "";
    private String bukkitPrId = "";
    private String workDirectory = "";
    private boolean remapped = false;
    private boolean generateJavadocs = false;
    private boolean generateSource = false;
    private boolean skipHttpsCheck = false;
    private boolean skipJavaVersionCheck = false;
    private boolean compileIfChanged = false;
    private boolean dontPullUpdates = false;
    private boolean compileSpigot = false;
    private boolean compileCraftbukkit = false;
    private boolean compileNone = false;
    private boolean overrideJavaExecutable = false;

    public List<String> getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--nogui");
        if (this.version.equals("experimental")) {
            args.add("--experimental");
            if (this.outputDirectory != null && !this.outputDirectory.isEmpty()) {
                args.add("--output-dir");
                args.add(this.outputDirectory);
            }
            if (!this.finalName.isEmpty()) {
                args.add("--final-name");
                args.add(this.finalName);
            }
            return args;
        }
        if (!this.version.equals("latest")) {
            args.add("--rev");
            args.add(this.version);
        }
        if (!this.spigotPrId.isEmpty()) {
            args.add("--pr");
            args.add(this.spigotPrId);
        }
        if (!this.bukkitPrId.isEmpty()) {
            args.add("--pr");
            args.add(this.bukkitPrId);
        }
        if (!this.craftbukkitPrId.isEmpty()) {
            args.add("--pr");
            args.add(this.craftbukkitPrId);
        }
        if (this.remapped) {
            args.add("--remapped");
        }
        if (this.generateJavadocs) {
            args.add("--generate-docs");
        }
        if (this.generateSource) {
            args.add("--generate-source");
        }
        if (this.skipHttpsCheck) {
            args.add("--disable-certificate-check");
        }
        if (this.skipJavaVersionCheck) {
            args.add("--disable-java-check");
        }
        if (this.compileIfChanged) {
            args.add("--compile-if-changed");
        }
        if (this.dontPullUpdates) {
            args.add("--dont-update");
        }
        if (this.compileNone) {
            args.add("--compile");
            args.add("NONE");
        } else if (this.compileSpigot && this.compileCraftbukkit) {
            args.add("--compile");
            args.add("SPIGOT,CRAFTBUKKIT");
        } else if (this.compileSpigot) {
            args.add("--compile");
            args.add("SPIGOT");
        } else if (this.compileCraftbukkit) {
            args.add("--compile");
            args.add("CRAFTBUKKIT");
        }
        if (this.outputDirectory != null && !this.outputDirectory.isEmpty()) {
            args.add("--output-dir");
            args.add(this.outputDirectory);
        }
        if (!this.finalName.isEmpty()) {
            args.add("--final-name");
            args.add(this.finalName);
        }
        return args;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String directory) {
        this.outputDirectory = directory;
    }

    public void setCompile(boolean spigot, boolean craftbukkit) {
        this.compileNone = !spigot && !craftbukkit;
        this.compileSpigot = spigot;
        this.compileCraftbukkit = craftbukkit;
    }

    public void setCompile(boolean none) {
        this.compileNone = none;
    }

    public void setFinalName(String finalName) {
        if (finalName.isEmpty()) {
            this.finalName = finalName;
            return;
        }
        if (finalName.startsWith(".")) {
            this.finalName = "";
            return;
        }
        if (!finalName.endsWith(".jar")) {
            finalName = finalName + ".jar";
        }
        this.finalName = finalName;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getFinalName() {
        return this.finalName;
    }

    @Generated
    public String getSpigotPrId() {
        return this.spigotPrId;
    }

    @Generated
    public String getCraftbukkitPrId() {
        return this.craftbukkitPrId;
    }

    @Generated
    public String getBukkitPrId() {
        return this.bukkitPrId;
    }

    @Generated
    public String getWorkDirectory() {
        return this.workDirectory;
    }

    @Generated
    public boolean isRemapped() {
        return this.remapped;
    }

    @Generated
    public boolean isGenerateJavadocs() {
        return this.generateJavadocs;
    }

    @Generated
    public boolean isGenerateSource() {
        return this.generateSource;
    }

    @Generated
    public boolean isSkipHttpsCheck() {
        return this.skipHttpsCheck;
    }

    @Generated
    public boolean isSkipJavaVersionCheck() {
        return this.skipJavaVersionCheck;
    }

    @Generated
    public boolean isCompileIfChanged() {
        return this.compileIfChanged;
    }

    @Generated
    public boolean isDontPullUpdates() {
        return this.dontPullUpdates;
    }

    @Generated
    public boolean isCompileSpigot() {
        return this.compileSpigot;
    }

    @Generated
    public boolean isCompileCraftbukkit() {
        return this.compileCraftbukkit;
    }

    @Generated
    public boolean isCompileNone() {
        return this.compileNone;
    }

    @Generated
    public boolean isOverrideJavaExecutable() {
        return this.overrideJavaExecutable;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setSpigotPrId(String spigotPrId) {
        this.spigotPrId = spigotPrId;
    }

    @Generated
    public void setCraftbukkitPrId(String craftbukkitPrId) {
        this.craftbukkitPrId = craftbukkitPrId;
    }

    @Generated
    public void setBukkitPrId(String bukkitPrId) {
        this.bukkitPrId = bukkitPrId;
    }

    @Generated
    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    @Generated
    public void setRemapped(boolean remapped) {
        this.remapped = remapped;
    }

    @Generated
    public void setGenerateJavadocs(boolean generateJavadocs) {
        this.generateJavadocs = generateJavadocs;
    }

    @Generated
    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    @Generated
    public void setSkipHttpsCheck(boolean skipHttpsCheck) {
        this.skipHttpsCheck = skipHttpsCheck;
    }

    @Generated
    public void setSkipJavaVersionCheck(boolean skipJavaVersionCheck) {
        this.skipJavaVersionCheck = skipJavaVersionCheck;
    }

    @Generated
    public void setCompileIfChanged(boolean compileIfChanged) {
        this.compileIfChanged = compileIfChanged;
    }

    @Generated
    public void setDontPullUpdates(boolean dontPullUpdates) {
        this.dontPullUpdates = dontPullUpdates;
    }

    @Generated
    public void setCompileSpigot(boolean compileSpigot) {
        this.compileSpigot = compileSpigot;
    }

    @Generated
    public void setCompileCraftbukkit(boolean compileCraftbukkit) {
        this.compileCraftbukkit = compileCraftbukkit;
    }

    @Generated
    public void setCompileNone(boolean compileNone) {
        this.compileNone = compileNone;
    }

    @Generated
    public void setOverrideJavaExecutable(boolean overrideJavaExecutable) {
        this.overrideJavaExecutable = overrideJavaExecutable;
    }
}

