/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.data;

import com.jeff_media.javafinder.JavaFinder;
import com.jeff_media.javafinder.JavaInstallation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JavaInstallationManager {
    private final List<JavaInstallation> installations = JavaFinder.builder().build().findInstallations();
    private final JavaInstallation primaryInstallation;
    private JavaInstallation selectedInstallation = this.primaryInstallation = JavaInstallationManager.fetchPrimaryInstallation(this.installations);
    private final List<String> jvmArguments = new ArrayList<String>();

    public JavaInstallationManager() {
        this.jvmArguments.add("-Xms512M");
    }

    public JavaInstallation getPrimaryInstallation() {
        return this.primaryInstallation;
    }

    public JavaInstallation getSelectedInstallation() {
        return this.selectedInstallation;
    }

    public List<JavaInstallation> getInstallations() {
        return this.installations;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public void setSelectedInstallation(JavaInstallation javaInstallation) {
        this.selectedInstallation = javaInstallation;
    }

    public void setJvmArguments(String arguments) {
        this.jvmArguments.clear();
        this.jvmArguments.addAll(Arrays.asList(arguments.split(" ")));
    }

    private static JavaInstallation fetchPrimaryInstallation(List<JavaInstallation> installations) {
        for (JavaInstallation installation : installations) {
            if (!installation.isCurrentJavaVersion()) continue;
            return installation;
        }
        return null;
    }
}

