/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import org.spigotmc.builder.BuildInfo;
import org.spigotmc.builder.Builder;
import org.spigotmc.gui.BuildToolsProcess;
import org.spigotmc.gui.Theme;
import org.spigotmc.gui.attributes.Lockable;
import org.spigotmc.gui.data.BuildData;
import org.spigotmc.gui.data.BuildSettings;
import org.spigotmc.gui.panels.ThemeSwitcherPanel;
import org.spigotmc.gui.panels.about.AboutPanel;
import org.spigotmc.gui.panels.general.GeneralPanel;
import org.spigotmc.gui.panels.options.OptionsPanel;
import org.spigotmc.utils.Constants;
import org.spigotmc.utils.SwingUtils;
import org.spigotmc.utils.Utils;

public class BuildToolsGui
extends JFrame
implements Lockable {
    private final BuildData buildData;
    private final BuildSettings buildSettings;
    private List<String> temp = new ArrayList<String>();
    private JTabbedPane menuPane;
    private GeneralPanel generalPanel;
    private OptionsPanel optionsPanel;
    private AboutPanel aboutPanel;
    private int currentTab;

    public static void main(String[] args) {
        SwingUtils.applyInitialTheme();
        BuildToolsGui gui = new BuildToolsGui();
        gui.setLocationRelativeTo(null);
        gui.setVisible(true);
    }

    public BuildToolsGui() {
        Builder.CWD = Utils.getFile().getParentFile();
        this.buildSettings = new BuildSettings();
        Theme.LIGHT.apply();
        this.setDefaultCloseOperation(3);
        this.setSize(new Dimension(1200, 700));
        this.setTitle("BuildTools");
        SwingUtils.applyIcon(this);
        this.buildData = new BuildData(this::onDataReceived);
        this.initComponents();
        this.menuPane.addChangeListener(this::onTabChange);
        SwingUtils.toggleLockComponents(this, Lockable.LockReason.START);
        SwingUtils.changeTheme(this, Theme.LIGHT);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BuildToolsProcess buildToolsProcess = BuildToolsGui.this.generalPanel.getBuildToolsProcess();
                if (buildToolsProcess == null) {
                    return;
                }
                Process process = buildToolsProcess.getProcess();
                if (process == null) {
                    return;
                }
                process.destroyForcibly();
            }
        });
    }

    private void initComponents() {
        this.menuPane = new JTabbedPane();
        this.menuPane.setEnabled(false);
        this.generalPanel = new GeneralPanel(this.buildData, this.buildSettings, this);
        this.menuPane.addTab("General", this.generalPanel);
        this.optionsPanel = new OptionsPanel(this.generalPanel, this.buildData, this.buildSettings);
        this.menuPane.addTab("Options", this.optionsPanel);
        this.aboutPanel = new AboutPanel();
        this.menuPane.addTab("About", this.aboutPanel);
        ThemeSwitcherPanel themeSwitcherPanel = new ThemeSwitcherPanel(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 1108, Short.MAX_VALUE).addComponent(themeSwitcherPanel, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.menuPane, GroupLayout.Alignment.TRAILING)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(themeSwitcherPanel, -2, -1, -2).addGap(0, 667, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.menuPane, -1, 700, Short.MAX_VALUE)));
    }

    private void onDataReceived(Map<String, Supplier<CompletableFuture<BuildInfo>>> buildInfo) {
        try {
            this.menuPane.setEnabled(true);
            this.generalPanel.getVersionWarningPane().setWarningText(null, null);
            this.generalPanel.getSettingsPanel().setVersions(this.buildData.getVersions());
            this.optionsPanel.setJavaExecutable(this.buildData.getJavaInstallationManager().getSelectedInstallation());
            SwingUtils.toggleLockComponents(this, Lockable.LockReason.START);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onTabChange(ChangeEvent event) {
        if (!(event.getSource() instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane pane = (JTabbedPane)event.getSource();
        if (pane.getSelectedIndex() == 0 && this.currentTab == 1) {
            List<String> preCompilationText = this.buildData.generatePreCompilationText(this.buildSettings);
            if (this.temp.equals(preCompilationText)) {
                return;
            }
            this.generalPanel.getConsolePane().updateConsoleAreaText(this.buildData.generatePreCompilationText(this.buildSettings));
        }
        if (pane.getSelectedIndex() == 1) {
            this.temp = this.buildData.generatePreCompilationText(this.buildSettings);
            this.optionsPanel.setJavaExecutable(this.buildData.getJavaInstallationManager().getSelectedInstallation());
        }
        if (pane.getSelectedIndex() == 2) {
            this.aboutPanel.setAboutHeaderImage(Utils.randomElement(Constants.LOGO.getImage().getScaledInstance(64, 64, 1), Constants.LOGO_ABOUT_EASTER_EGG.getImage(), 20));
        }
        this.currentTab = pane.getSelectedIndex();
    }

    @Override
    public void onLockToggle(Lockable.LockReason reason) {
        if (reason == Lockable.LockReason.BUILD) {
            this.menuPane.setEnabledAt(1, !this.menuPane.isEnabledAt(1));
        }
    }
}

