/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class AndRevFilter
extends RevFilter {
    public static RevFilter create(RevFilter a, RevFilter b) {
        if (a == ALL) {
            return b;
        }
        if (b == ALL) {
            return a;
        }
        return new Binary(a, b);
    }

    private static class Binary
    extends AndRevFilter {
        private final RevFilter a;
        private final RevFilter b;
        private final boolean requiresCommitBody;

        Binary(RevFilter one, RevFilter two) {
            this.a = one;
            this.b = two;
            this.requiresCommitBody = this.a.requiresCommitBody() || this.b.requiresCommitBody();
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.a.include(walker, c) && this.b.include(walker, c);
        }

        @Override
        public boolean requiresCommitBody() {
            return this.requiresCommitBody;
        }

        @Override
        public RevFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " AND " + this.b.toString() + ")";
        }
    }
}

