/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.hooks.GitHook;
import org.eclipse.jgit.lib.Repository;

public class PrePushHook
extends GitHook<String> {
    private String remoteName;
    private String remoteLocation;
    private String refs;

    protected PrePushHook(Repository repo, PrintStream outputStream) {
        super(repo, outputStream);
    }

    @Override
    protected String getStdinArgs() {
        return this.refs;
    }

    @Override
    public String call() throws IOException, AbortedByHookException {
        if (this.canRun()) {
            this.doRun();
        }
        return "";
    }

    private boolean canRun() {
        return true;
    }

    @Override
    public String getHookName() {
        return "pre-push";
    }

    @Override
    protected String[] getParameters() {
        if (this.remoteName == null) {
            this.remoteName = this.remoteLocation;
        }
        return new String[]{this.remoteName, this.remoteLocation};
    }

    public void setRemoteName(String name) {
        this.remoteName = name;
    }

    public void setRemoteLocation(String location) {
        this.remoteLocation = location;
    }
}

