/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.hooks;

import java.io.PrintStream;
import java.text.MessageFormat;
import org.eclipse.jgit.hooks.CommitMsgHook;
import org.eclipse.jgit.hooks.PostCommitHook;
import org.eclipse.jgit.hooks.PreCommitHook;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.LfsFactory;

public class Hooks {
    public static PreCommitHook preCommit(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new PreCommitHook(repo, outputStream, errorStream);
    }

    public static PostCommitHook postCommit(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new PostCommitHook(repo, outputStream, errorStream);
    }

    public static CommitMsgHook commitMsg(Repository repo, PrintStream outputStream, PrintStream errorStream) {
        return new CommitMsgHook(repo, outputStream, errorStream);
    }

    public static PrePushHook prePush(Repository repo, PrintStream outputStream) {
        PrePushHook hook;
        if (LfsFactory.getInstance().isAvailable() && (hook = LfsFactory.getInstance().getPrePushHook(repo, outputStream)) != null) {
            if (hook.isNativeHookPresent()) {
                PrintStream ps = outputStream;
                if (ps == null) {
                    ps = System.out;
                }
                ps.println(MessageFormat.format(JGitText.get().lfsHookConflict, repo));
            }
            return hook;
        }
        return new PrePushHook(repo, outputStream);
    }
}

