/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.panels.general.settings;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.spigotmc.builder.Builder;
import org.spigotmc.gui.Theme;
import org.spigotmc.gui.attributes.Lockable;
import org.spigotmc.gui.attributes.Themeable;
import org.spigotmc.gui.components.PlaceholderTextField;
import org.spigotmc.gui.data.BuildData;
import org.spigotmc.gui.data.BuildSettings;
import org.spigotmc.gui.data.ThemePack;
import org.spigotmc.gui.panels.general.console.ConsolePane;
import org.spigotmc.gui.panels.general.settings.VersionWarningPane;
import org.spigotmc.utils.Constants;
import org.spigotmc.utils.SwingUtils;

public class SettingsPanel
extends JPanel
implements Lockable,
Themeable {
    private JComboBox<String> versionComboBox;
    private PlaceholderTextField outputDirField;
    private PlaceholderTextField finalNameField;
    private JButton openDirButton;
    private JButton outputSelectionButton;
    private final BuildData buildData;
    private final BuildSettings buildSettings;
    private final ConsolePane consolePane;
    private final VersionWarningPane versionWarningPane;

    public SettingsPanel(BuildData buildData, BuildSettings buildSettings, ConsolePane consolePane, VersionWarningPane versionWarningPane) {
        this.buildData = buildData;
        this.buildSettings = buildSettings;
        this.consolePane = consolePane;
        this.versionWarningPane = versionWarningPane;
        this.initComponents();
    }

    private void initComponents() {
        this.versionComboBox = new JComboBox();
        this.versionComboBox.addItem("Loading...");
        this.versionComboBox.setFont(Constants.GENERAL_FONT);
        this.versionComboBox.addActionListener(this::versionComboBoxActionPerformed);
        this.versionComboBox.setToolTipText("The version you want to build.");
        JLabel selectLabel = new JLabel("Select Version");
        JLabel finalLabel = new JLabel("Final Name (Optional)");
        this.finalNameField = new PlaceholderTextField();
        this.finalNameField.setPlaceholder("server.jar");
        this.finalNameField.setFont(Constants.GENERAL_FONT);
        this.finalNameField.setToolTipText("The name of the final jar.");
        this.finalNameField.setMargin(new Insets(8, 8, 8, 8));
        this.finalNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SettingsPanel.this.finalNameFieldKeyReleased(keyEvent);
            }
        });
        JLabel outputDirLabel = new JLabel("Output Directory (Optional)");
        this.outputDirField = new PlaceholderTextField();
        this.outputDirField.setPlaceholder(Builder.CWD.toString());
        this.outputDirField.setFont(Constants.GENERAL_FONT);
        this.outputDirField.setToolTipText("The directory where the final jar will be copied to.");
        this.outputDirField.setMargin(new Insets(8, 8, 8, 8));
        this.outputDirField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                SettingsPanel.this.outputDirFieldKeyReleased(event);
            }
        });
        this.outputSelectionButton = new JButton("Select");
        this.outputSelectionButton.setToolTipText("Select the output directory.");
        this.outputSelectionButton.setMargin(new Insets(8, 16, 8, 16));
        this.outputSelectionButton.addActionListener(this::outputSelectionButtonActionPerformed);
        this.outputSelectionButton.setCursor(Cursor.getPredefinedCursor(12));
        this.openDirButton = new JButton();
        this.openDirButton.setToolTipText("Open the output directory.");
        this.openDirButton.setMargin(new Insets(8, 16, 8, 16));
        this.openDirButton.addActionListener(this::openDirButtonActionPerformed);
        this.openDirButton.setCursor(Cursor.getPredefinedCursor(12));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionComboBox, -2, 265, -2).addComponent(selectLabel)).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.finalNameField, -2, 265, -2).addComponent(finalLabel)).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.outputDirField, -1, 447, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputSelectionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openDirButton)).addGroup(layout.createSequentialGroup().addComponent(outputDirLabel).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(finalLabel).addComponent(selectLabel)).addComponent(outputDirLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionComboBox, -2, 32, -2).addComponent(this.finalNameField, -2, 32, -2).addComponent(this.outputDirField, -2, 32, -2).addComponent(this.openDirButton, -2, 32, -2).addComponent(this.outputSelectionButton, -2, 32, -2)).addGap(0, 0, 0)));
    }

    private void versionComboBoxActionPerformed(ActionEvent event) {
        JComboBox box = (JComboBox)event.getSource();
        String selected = (String)box.getSelectedItem();
        if (selected == null) {
            return;
        }
        switch (selected) {
            case "experimental": {
                this.versionWarningPane.setWarningText("WARNING: Experimental builds should not be run in production! You will NOT receive support if you use an experimental jar to run your server!! YOU HAVE BEEN WARNED!!!", Constants.EXPERIMENTAL_WARNING_TEXT_PRIMARY);
                this.finalNameField.setPlaceholder("spigot-experimental.jar");
                break;
            }
            case "latest": {
                this.versionWarningPane.setWarningText("NOTE: 'latest' refers to the latest stable version and may not necessarily correlate to the absolute newest version available!", null);
                String name = "spigot-%version%.jar".replace("%version%", this.buildData.getLatestVersion());
                this.finalNameField.setPlaceholder(name);
                break;
            }
            default: {
                this.versionWarningPane.setWarningText(null, null);
                String name = "spigot-%version%.jar".replace("%version%", selected);
                this.finalNameField.setPlaceholder(name);
            }
        }
        this.finalNameField.updateUI();
        this.buildSettings.setVersion(selected);
        if (!this.buildSettings.isOverrideJavaExecutable()) {
            this.buildData.updateJavaExecutable(this.buildSettings, false);
        }
        this.consolePane.updateConsoleAreaText(this.buildData.generatePreCompilationText(this.buildSettings));
    }

    private void finalNameFieldKeyReleased(KeyEvent event) {
        JTextField field = (JTextField)event.getSource();
        this.buildSettings.setFinalName(field.getText());
        this.consolePane.updateConsoleAreaText(this.buildData.generatePreCompilationText(this.buildSettings));
    }

    private void outputDirFieldKeyReleased(KeyEvent event) {
        JTextField field = (JTextField)event.getSource();
        this.buildSettings.setOutputDirectory(field.getText());
        this.consolePane.updateConsoleAreaText(this.buildData.generatePreCompilationText(this.buildSettings));
        SwingUtils.validatePath(field);
    }

    private void outputSelectionButtonActionPerformed(ActionEvent event) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selection = chooser.getSelectedFile();
            this.outputDirField.setText(selection.getAbsolutePath());
            this.buildSettings.setOutputDirectory(selection.getAbsolutePath());
            this.consolePane.updateConsoleAreaText(this.buildData.generatePreCompilationText(this.buildSettings));
        }
        SwingUtils.validatePath(this.outputDirField);
    }

    private void openDirButtonActionPerformed(ActionEvent event) {
        if (!this.buildSettings.getWorkDirectory().isEmpty() && this.buildSettings.getOutputDirectory().isEmpty()) {
            SwingUtils.open(this.buildSettings.getWorkDirectory());
        } else if (!this.buildSettings.getOutputDirectory().isEmpty()) {
            SwingUtils.open(this.buildSettings.getOutputDirectory());
        } else {
            SwingUtils.open(Builder.CWD.toString());
        }
    }

    public void setVersions(List<String> versions) {
        this.versionComboBox.removeAllItems();
        for (String version : versions) {
            this.versionComboBox.addItem(version);
        }
        this.versionComboBox.setSelectedIndex(1);
    }

    public PlaceholderTextField getOutputDirField() {
        return this.outputDirField;
    }

    @Override
    public void onLockToggle(Lockable.LockReason reason) {
        this.versionComboBox.setEnabled(!this.versionComboBox.isEnabled());
        this.finalNameField.setEnabled(!this.finalNameField.isEnabled());
        this.outputDirField.setEnabled(!this.outputDirField.isEnabled());
        this.outputSelectionButton.setEnabled(!this.outputSelectionButton.isEnabled());
        if (this.versionComboBox.isEnabled()) {
            this.versionComboBox.requestFocus();
        }
    }

    @Override
    public void onThemeChange(Theme theme) {
        ThemePack themePack = ThemePack.fromTheme(theme);
        Color borderColor = (Color)themePack.getAsset(ThemePack.Asset.BORDER_COLOR);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(borderColor), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        ImageIcon folderIcon = (ImageIcon)themePack.getAsset(ThemePack.Asset.FOLDER);
        this.openDirButton.setIcon(folderIcon);
    }
}

