/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.modals;

import com.jeff_media.javafinder.JavaInstallation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.spigotmc.gui.components.ColumnsAutoSizer;
import org.spigotmc.gui.data.JavaInstallationManager;
import org.spigotmc.gui.panels.options.OptionsPanel;
import org.spigotmc.utils.SwingUtils;

public class SelectJavaModal
extends JFrame {
    private JTable javaTable;
    private final OptionsPanel optionsPanel;
    private final JavaInstallationManager javaInstallationManager;
    private final Map<Integer, JavaInstallation> tableInstallationMap;

    public SelectJavaModal(OptionsPanel optionsPanel, JavaInstallationManager javaInstallationManager) {
        this.optionsPanel = optionsPanel;
        this.javaInstallationManager = javaInstallationManager;
        this.tableInstallationMap = new HashMap<Integer, JavaInstallation>();
        SwingUtils.applyIcon(this);
        this.setDefaultCloseOperation(2);
        this.setTitle("Select a Java Version");
        this.setSize(new Dimension(600, 500));
        this.initComponents();
        this.javaTable.getModel().addTableModelListener(event -> ColumnsAutoSizer.sizeColumnsToFit(this.javaTable));
        DefaultTableModel model = (DefaultTableModel)this.javaTable.getModel();
        for (JavaInstallation installation : javaInstallationManager.getInstallations()) {
            this.tableInstallationMap.put(model.getRowCount(), installation);
            model.insertRow(model.getRowCount(), new Object[]{installation.isCurrentJavaVersion(), (Object)((Object)installation.getType()) + " " + installation.getVersion().getMajor(), installation.getJavaExecutable().getAbsolutePath()});
        }
        this.javaTable.setColumnSelectionAllowed(false);
        this.javaTable.setRowSelectionAllowed(true);
        this.javaTable.changeSelection(0, 0, false, false);
    }

    private void initComponents() {
        this.javaTable = new JTable();
        this.javaTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Primary", "Version", "Path"}){
            Class<?>[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.javaTable.setAutoResizeMode(1);
        this.javaTable.setColumnSelectionAllowed(true);
        this.javaTable.getTableHeader().setReorderingAllowed(false);
        this.javaTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.javaTable.getColumnModel().getColumnCount() > 0) {
            this.javaTable.getColumnModel().getColumn(0).setResizable(false);
            this.javaTable.getColumnModel().getColumn(1).setResizable(false);
            this.javaTable.getColumnModel().getColumn(2).setResizable(false);
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.javaTable);
        JLabel titleLabel = new JLabel("Select a Java Version");
        JButton selectButton = new JButton("Select");
        selectButton.setMargin(new Insets(8, 16, 8, 16));
        selectButton.addActionListener(this::selectButtonActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(scrollPane, -1, 588, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(titleLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(265, 265, 265).addComponent(selectButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(scrollPane, -1, 412, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(selectButton).addContainerGap()));
        this.pack();
    }

    private void selectButtonActionPerformed(ActionEvent event) {
        JavaInstallation installation = this.tableInstallationMap.get(this.javaTable.getSelectedRow());
        this.javaInstallationManager.setSelectedInstallation(installation);
        this.optionsPanel.setJavaExecutable(installation);
        this.dispose();
    }
}

