/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class BuildToolsProcess {
    private final OutputStream output;
    private final ProcessBuilder builder;
    private Process process;
    private File workDirectory;

    public BuildToolsProcess(List<String> args, OutputStream output, File workDirectory) {
        this.builder = new ProcessBuilder(args.toArray(new String[0])).redirectErrorStream(true);
        this.output = output;
        this.workDirectory = workDirectory;
    }

    public Process execute() throws IOException {
        int in;
        if (this.workDirectory.exists()) {
            this.builder.directory(this.workDirectory);
        }
        this.process = this.builder.start();
        InputStream input = this.process.getInputStream();
        while ((in = input.read()) != -1) {
            this.output.write(in);
        }
        return this.process;
    }

    public Process getProcess() {
        return this.process;
    }

    public File getWorkDirectory() {
        return this.workDirectory;
    }
}

