/*
 * Decompiled with CFR 0.152.
 */
package com.jeff_media.javafinder;

import org.jetbrains.annotations.NotNull;

public enum OperatingSystem {
    MACOS,
    LINUX,
    OTHER,
    WINDOWS("java.exe", "javac.exe");

    @NotNull
    public static final OperatingSystem CURRENT;
    @NotNull
    private final String javaExecutableName;
    @NotNull
    private final String javacExecutableName;

    private OperatingSystem(String javaExecutableName, String javacExecutableName) {
        this.javaExecutableName = javaExecutableName;
        this.javacExecutableName = javacExecutableName;
    }

    private OperatingSystem() {
        this("java", "javac");
    }

    @NotNull
    private static OperatingSystem getCurrentOS() {
        String osName = System.getProperty("os.name");
        String string = osName = osName == null ? "" : osName.toLowerCase();
        if (osName.startsWith("mac")) {
            return MACOS;
        }
        if (osName.startsWith("linux")) {
            return LINUX;
        }
        if (osName.startsWith("windows")) {
            return WINDOWS;
        }
        return OTHER;
    }

    @NotNull
    public String getJavaExecutableName() {
        return this.javaExecutableName;
    }

    @NotNull
    public String getJavacExecutableName() {
        return this.javacExecutableName;
    }

    static {
        CURRENT = OperatingSystem.getCurrentOS();
    }
}

